/*
  Plee The Bear

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file frame_screen.hpp
 * \brief This frame is shown for choose the screen parameters.
 * \author Sebastien Angibaud
 */
#ifndef __PTB_FRAME_SCREEN_HPP__
#define __PTB_FRAME_SCREEN_HPP__

#include "ptb/frame/frame.hpp"
#include "ptb/frame/menu.hpp"
#include "ptb/frame/text_box.hpp"

namespace ptb
{
  /**
   * \brief This frame is shown for choose the screen parameters.
   * \author Sebastien Angibaud
   */
  class frame_screen : public frame
  {
  public:
    frame_screen( windows_layer* in_layer );

  private:
    bool on_key_press( bear::input::keyboard::key_code key );
    bool on_button_press( bear::input::joystick::joy_code button,
                          unsigned int joy_index );
    bool on_mouse_press( bear::input::mouse::mouse_code key,
                         const claw::math::coordinate_2d<unsigned int>& pos );
    void validate();
    void create_controls();
    void write_mode();

    void save();

  private:
    /** \brief Text zones. */
    menu* m_menu;

    /* \brief The full screen mode when the frame is shown. */
    const bool m_saved_mode;

    /** \brief The mode text. */
    text_box* m_text;

    /**
     * \name Actions in the menu.
     * The positions of the actions in the menu.
     */
    /** \{ */
    static const unsigned int s_pos_full_screen;
    static const unsigned int s_pos_ok;
    static const unsigned int s_pos_cancel;
    /** \} */

    /** \brief The width of the margins. */
    static const unsigned int s_margin;

    /** \brief The height of the line_space. */
    static const unsigned int s_line_space;

  }; // class frame_pause
} // namespace ptb

#endif // __PTB_FRAME_PAUSE_HPP__
