/*
  Plee The Bear

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file text_box.hpp
 * \brief This class is a bear::gui::static_text in a bear::gui::frame with
 *        borders.
 * \author Julien Jorge
 */
#ifndef __PTB_TEXT_BOX_HPP__
#define __PTB_TEXT_BOX_HPP__

#include "ptb/frame/frame.hpp"
#include "gui/static_text.hpp"

namespace ptb
{
  /**
   * \brief This class is a bear::gui::static_text in a bear::gui::frame with
   *        borders.
   * \author Julien Jorge
   */
  class text_box : public bear::gui::visual_component
  {
  public:
    text_box( frame* owner );

    void set_text( const std::string& text );
    const std::string& get_text() const;

  private:
    void on_resized();

    bear::visual::sprite* create_vertical_border() const;
    bear::visual::sprite* create_horizontal_border() const;
    bear::visual::sprite* create_background() const;

  private:
    /** \brief The borders of the box. */
    bear::gui::frame* m_frame;

    /** \brief The text in the box. */
    bear::gui::static_text* m_text;

  }; // class text_box
} // namespace ptb

#endif // __PTB_TEXT_BOX_HPP__
