/*
  Plee The Bear

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file gossipy_item.cpp
 * \brief Implementation of the ptb::gossipy_item class.
 * \author Sbastien Angibaud
 */
#include "ptb/item/gossipy_item.hpp"
#include "engine/export.hpp"

BASE_ITEM_EXPORT( gossipy_item, ptb )

/*----------------------------------------------------------------------------*/
/**
 * \brief Constructor.
 */
ptb::gossipy_item::gossipy_item()
  : m_speaking(false)
{
  set_speaker_item(this);
} // gossipy_item::gossipy_item()

/*----------------------------------------------------------------------------*/
/**
 * \brief Initialize the item.
 */
void ptb::gossipy_item::start()
{
  m_speaking = speak();
} // gossipy_item::start()

/*----------------------------------------------------------------------------*/
/**
 * \brief Do one iteraton in the progression of the item.
 * \param elapsed_time Elapsed time sice the last call.
 */
void ptb::gossipy_item::progress( bear::universe::time_type elapsed_time )
{
  if ( !m_speaking )
    m_speaking = speak();
} // gossipy_item::progress()
