/*
  Plee The Bear

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file state_crouch.cpp
 * \brief Implementation of the ptb::state_crouch class.
 * \author Sebastien Angibaud
 */
#include "ptb/item/plee/state_crouch.hpp"

/*----------------------------------------------------------------------------*/
/**
 * \brief Constructor.
 */
ptb::state_crouch::state_crouch( ptb::plee* plee_instance )
  : state_plee(plee_instance)
{

} // state_crouch::state_crouch()

/*----------------------------------------------------------------------------*/
/**
 * \brief Return the name of the state.
 */
std::string ptb::state_crouch::get_name() const
{
  return "crouch";
} // state_crouch::get_name()

/*----------------------------------------------------------------------------*/
/**
 * \brief Initialization of this state.
 */
void ptb::state_crouch::start()
{
  m_plee_instance->start_action_parent("crouch");
} // state_crouch::start()

/*---------------------------------------------------------------------------*/
/**
 * \brief Do one iteration in the progression of the item.
 * \param elapsed_time Elapsed time since the last call.
 */
void ptb::state_crouch::progress( bear::universe::time_type elapsed_time )
{
  super::progress(elapsed_time);

  test_walk();
  test_in_sky();
} // state_crouch::progress()

/*----------------------------------------------------------------------------*/
/**
 * \brief Stop to look up.
 */
void ptb::state_crouch::do_stop_crouch()
{
  if ( m_plee_instance->get_status_look_up() ) 
    m_plee_instance->set_state(plee::look_up_state);
  else
    m_plee_instance->set_state(plee::idle_state);
} // state_crouch::do_stop_crouch()

/*----------------------------------------------------------------------------*/
/**
 * \brief Make the plee look up.
 */
void ptb::state_crouch::do_look_up()
{
  m_plee_instance->set_state(plee::look_up_state);
} // state_crouch::do_look_up()


/*----------------------------------------------------------------------------*/
/**
 * \brief Continue to look up.
 */
void ptb::state_crouch::do_continue_look_up()
{
  if ( !m_plee_instance->get_status_look_up() ) 
    m_plee_instance->do_start_look_up();
} // state_crouch::do_continue_look_up()
