/*
  Plee The Bear

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file state_idle.cpp
 * \brief Implementation of the ptb::state_idle class.
 * \author Sebastien Angibaud
 */
#include "ptb/item/plee/state_idle.hpp"

const bear::universe::time_type ptb::state_idle::s_time_to_wait = 3;

/*----------------------------------------------------------------------------*/
/**
 * \brief Constructor.
 */
ptb::state_idle::state_idle( ptb::plee* plee_instance )
  : state_plee(plee_instance)
{

} // state_idle::state_idle()

/*----------------------------------------------------------------------------*/
/**
 * \brief Return the name of the state.
 */
std::string ptb::state_idle::get_name() const
{
  return "idle";
} // state_idle::get_name()

/*----------------------------------------------------------------------------*/
/**
 * \brief Initialization of this state.
 */
void ptb::state_idle::start()
{
  m_plee_instance->start_action_parent("idle");
  m_idle_time = 0;
} // state_idle::start()

/*---------------------------------------------------------------------------*/
/**
 * \brief Do one iteration in the progression of the item.
 * \param elapsed_time Elapsed time since the last call.
 */
void ptb::state_idle::progress( bear::universe::time_type elapsed_time )
{
  super::progress(elapsed_time);

  if ( m_plee_instance->has_bottom_contact() ) 
    {
      if ( !test_walk() ) 
        {
          m_idle_time += elapsed_time;
          
          if ( m_idle_time >= s_time_to_wait )
            m_plee_instance->set_state(plee::wait_state);
        }
    }
  else
    test_in_sky();
} // state_idle::progress()

/*----------------------------------------------------------------------------*/
/**
 * \brief Make the plee look up.
 */
void ptb::state_idle::do_look_up()
{
  m_plee_instance->set_state(plee::look_up_state);
} // state_idle::do_look_up()


/*----------------------------------------------------------------------------*/
/**
 * \brief Continue to look up.
 */
void ptb::state_idle::do_continue_look_up()
{
  m_plee_instance->do_start_look_up();
} // state_idle::do_continue_look_up()



/*----------------------------------------------------------------------------*/
/**
 * \brief Make the plee crouch.
 */
void ptb::state_idle::do_crouch()
{
  m_plee_instance->set_state(plee::crouch_state);
} // state_idle::do_crouch()


/*----------------------------------------------------------------------------*/
/**
 * \brief Continue to crouch.
 */
void ptb::state_idle::do_continue_crouch()
{
  m_plee_instance->do_start_crouch();
} // state_idle::do_continue_crouch()
