/*
  Plee The Bear

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file state_jump.cpp
 * \brief Implementation of the ptb::state_jump class.
 * \author Sebastien Angibaud
 */
#include "ptb/item/plee/state_jump.hpp"


/*----------------------------------------------------------------------------*/
/**
 * \brief Constructor.
 */
ptb::state_jump::state_jump( ptb::plee* plee_instance  )
  : state_plee(plee_instance), m_had_jumped(false)
{
  
} // state_jump::state_jump()

/*----------------------------------------------------------------------------*/
/**
 * \brief Return the name of the state.
 */
std::string ptb::state_jump::get_name() const
{
  return "jump";
} // state_jump::get_name()

/*----------------------------------------------------------------------------*/
/**
 * \brief Initialization of this state.
 */
void ptb::state_jump::start()
{
  m_plee_instance->set_status_look_up(false);
  m_plee_instance->set_status_crouch(false);
  m_plee_instance->start_action_parent("jump");
  m_had_jumped = false; // change in the first progress
} // state_jump::start()

/*---------------------------------------------------------------------------*/
/**
 * \brief Do one iteration in the progression of the item.
 * \param elapsed_time Elapsed time since the last call.
 */
void ptb::state_jump::progress( bear::universe::time_type elapsed_time )
{
  super::progress(elapsed_time);

  if ( m_had_jumped )
    {
      if ( !test_bottom_contact() )
        {
          bear::universe::speed_type speed;
          speed = m_plee_instance->get_speed();
          
          if( speed.y >= 0 )
            m_plee_instance->set_state(plee::fall_state);
          // else
          // we continue the jump
        }
    }
  else
    m_had_jumped = true;
} // state_jump::progress()

/*----------------------------------------------------------------------------*/
/**
 * \brief Do a jump.
 */
void ptb::state_jump::do_jump()
{
  // we can't jump in this state.
} // state_jump::do_jump()
