/*
  Plee The Bear

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file state_throw.cpp
 * \brief Implementation of the ptb::state_throw class.
 * \author Sebastien Angibaud
 */
#include "ptb/item/plee/state_throw.hpp"

const bear::universe::time_type ptb::state_throw::s_time_to_throw = 0.3;

/*----------------------------------------------------------------------------*/
/**
 * \brief Constructor.
 */
ptb::state_throw::state_throw( plee* plee_instance )
  : state_plee(plee_instance)
{

} // state_throw::state_throw()

/*----------------------------------------------------------------------------*/
/**
 * \brief Return the name of the state.
 */
std::string ptb::state_throw::get_name() const
{
  return "throw";
} // state_throw::get_name()

/*----------------------------------------------------------------------------*/
/**
 * \brief Initialization of this state.
 */
void ptb::state_throw::start()
{
  m_plee_instance->start_action_parent("throw");
  m_throw_time = 0;
} // state_throw::start()

/*---------------------------------------------------------------------------*/
/**
 * \brief Do one iteration in the progression of the item.
 * \param elapsed_time Elapsed time since the last call.
 */
void ptb::state_throw::progress( bear::universe::time_type elapsed_time )
{
  super::progress(elapsed_time);

  m_throw_time += elapsed_time;

  if ( m_throw_time >= s_time_to_throw )
    {
      if ( m_plee_instance->get_status_look_up() )
        m_plee_instance->set_state(plee::look_up_state);
      else if ( m_plee_instance->get_status_crouch() )
        m_plee_instance->set_state(plee::crouch_state);
      else
        m_plee_instance->set_state(plee::idle_state);
    }
} // state_throw::progress()

/*----------------------------------------------------------------------------*/
/**
 * \brief Make the plee start throw.
 */
void ptb::state_throw::do_start_throw()
{
  // Plee can't throw an other stone.
} // state_throw::do_start_throw()
