/*
  Plee The Bear

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file state_start_throw.hpp
 * \brief The class describing the state where the player prepare
 * a horizontal throw.
 * \author Sebastien Angibaud
 */
#ifndef __PTB_STATE_START_THROW_HPP__
#define __PTB_STATE_START_THROW_HPP__

#include "ptb/item/plee/state_plee.hpp"

namespace ptb
{
  /**
   * \brief The class describing a state where the player start to throw.
   * \author Sebastien Angibaud
   */
  class state_start_throw : public state_plee
  {
  public:
    /** \brief The type of the parent class. */
    typedef state_plee super;

  public:
    state_start_throw(plee* player);

    virtual std::string get_name() const;
    virtual void start();
    virtual void progress( bear::universe::time_type elapsed_time );

    virtual void do_start_throw();
    virtual void do_stop_throw();
    virtual void do_look_up();
    virtual void do_continue_look_up();
    virtual void do_crouch();
    virtual void do_continue_crouch();

  private:
    bear::universe::force_type get_stone_force( bool up, bool down ) const;

  private:
    /** \brief Indicates that Plee want throw. */
    bool m_stop_wanted;

    /** \brief Indicates that Plee want throw up. */
    bool m_throw_up;

    /** \brief Indicates that Plee want throw down. */
    bool m_throw_down;

    /** \brief Elapsed time since we are in this state. */
    bear::universe::time_type m_throw_time;

    /** \brief The time over which Plee throw automatically. */
    static const bear::universe::time_type s_time_to_start_throw;

  }; // class state_start_throw
} // namespace ptb

#endif // __PTB_STATE_START_THROW_HPP__
