/*
  Plee The Bear

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file stone.cpp
 * \brief Implementation of the ptb::stone class.
 * \author Sbastien Angibaud
 */
#include "ptb/item/stone/stone.hpp"

/*----------------------------------------------------------------------------*/
/**
 * \brief Constructor.
 */
ptb::stone::stone( bear::engine::base_item::id_type id_creator )
  : m_id_creator(id_creator)
{
  set_friction(0.99);
  set_mass(1.3);
  set_gravity( bear::universe::force_type(0,1) );

  set_size(24, 24);

  m_monster_type = monster::stone_monster;
  m_energy = 15;
  m_offensive_force = 30;
  m_offensive_coefficients[normal_attack] = 1;
} // stone::stone()

/*---------------------------------------------------------------------------*/
/**
 * \brief Initialise the item.
 */
void ptb::stone::start()
{
  super::start();

  set_model("model/stone.cm");
  execute_action("default");
} // stone::start()

/*---------------------------------------------------------------------------*/
/**
 * \brief Do one iteration in the progression of the item.
 * \param elapsed_time Elapsed time since the last call.
 */
void ptb::stone::progress( bear::universe::time_type elapsed_time )
{
  if ( has_contact() )
      kill();
  else
    {  
      set_angle(get_angle() - 0.04);

      super::progress( elapsed_time );
    }
} // stone::progress()

/*----------------------------------------------------------------------------*/
/**
 * \brief The item has attacked.
 */
void ptb::stone::has_attacked()
{
  kill();
} // stone::has_attacked()

/*---------------------------------------------------------------------------*/
/**
 * \brief Inform the item tat he left the active region.
 */
void ptb::stone::left_active_region()
{
  kill();
} // ptb::stone::left_active_region()
