/*
  Plee The Bear

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file state_wasp_dead.cpp
 * \brief Implementation of the ptb::state_wasp_dead class.
 * \author Sebastien Angibaud
 */
#include "ptb/item/wasp/state_wasp_dead.hpp"

#include "engine/world.hpp"
#include "engine/game.hpp"
#include "ptb/item/headstone.hpp"

const unsigned int ptb::state_wasp_dead::s_soul_energy = 30;

/*----------------------------------------------------------------------------*/
/**
 * \brief Constructor.
 * \param wasp_instance The pointer on the wasp.
 */
ptb::state_wasp_dead::state_wasp_dead( ptb::wasp* wasp_instance )
  : state_wasp(wasp_instance),m_contact(false),
    m_item_contact(NULL)
{

} // state_wasp_dead::state_wasp_dead()

/*----------------------------------------------------------------------------*/
/**
 * \brief Return the name of the state.
 */
std::string ptb::state_wasp_dead::get_name() const
{
  return "dead";
} // state_wasp_dead::get_name()

/*---------------------------------------------------------------------------*/
/**
 * \brief Do one iteration in the progression of the item.
 * \param elapsed_time Elapsed time since the last call.
 */
void ptb::state_wasp_dead::progress( bear::universe::time_type elapsed_time )
{
  if ( m_contact )
    {
      create_headstone();
      m_wasp_instance->kill();
    }
  else if ( m_wasp_instance->has_contact() )
    m_contact = true;
  else
    m_wasp_instance->set_angle(m_wasp_instance->get_angle() + 0.2 );
  
} // state_wasp_dead::progress()

/*----------------------------------------------------------------------------*/
/**
 * \brief Tell that the item has a contact on its bottom.
 */
void ptb::state_wasp_dead::set_bottom_contact
(bear::universe::physical_item_state& item)
{
  m_item_contact = &item;
} // state_wasp_dead::set_bottom_contact()

/*----------------------------------------------------------------------------*/
/**
 * \brief Initialization of this state.
 */
void ptb::state_wasp_dead::start()
{
  m_wasp_instance->start_action_parent("dead");
  m_wasp_instance->set_mass(0.1);
  m_wasp_instance->set_offensive_phase(false);

  m_wasp_instance->set_integer_field( "gap_x", 
                                     - (int)m_wasp_instance->get_width()/2 );
  m_wasp_instance->set_real_field( "pos_x", 
                                   m_wasp_instance->get_center_of_mass().x);
  m_wasp_instance->set_real_field( "width", 1);
} // state_wasp_dead::start()

/*----------------------------------------------------------------------------*/
/**
 * \brief Create a headstone.
 */
void ptb::state_wasp_dead::create_headstone() const
{
  bear::engine::world* w = m_wasp_instance->get_owner();

  headstone* new_headstone = new headstone;

  bear::visual::animation* anim =
    new bear::visual::animation( m_wasp_instance->get_animation("soul") );
  anim->mirror(!m_wasp_instance->get_positive_orientation());

  new_headstone->set_animation_field("soul_animation", anim);
  new_headstone->set_real_field("pos_x", 
                                m_wasp_instance->get_center_of_mass().x -
                                new_headstone->get_width() / 2);
  new_headstone->set_real_field("pos_bottom", 
                                m_wasp_instance->get_position().y + 
                                m_wasp_instance->get_height() );

  bear::universe::physical_item* item = 
		dynamic_cast<bear::universe::physical_item*>(m_item_contact);

  if ( item != NULL ) 
    new_headstone->set_dependent_item(item);
  new_headstone->set_u_integer_field("energy", s_soul_energy);
  new_headstone->set_integer_field
    ( "pos_z",  m_wasp_instance->get_z_position() - 1 );

  w->register_item( new_headstone );

  CLAW_ASSERT( new_headstone->is_valid(),
               "The headstone of wasp isn't correctly initialized" );
  new_headstone->start();
} // state_wasp_dead::create_headtsone()

