/*
  Plee The Bear

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file sting.cpp
 * \brief Implementation of the ptb::sting class.
 * \author Sbastien Angibaud
 */
#include "ptb/item/wasp/sting.hpp"

#include "engine/game.hpp"
#include "engine/world.hpp"
#include "generic_items/decorative_item.hpp"

/*----------------------------------------------------------------------------*/
/**
 * \brief Constructor.
 */
ptb::sting::sting()
  : m_is_dead(false)
{
  set_size( 26, 26 );

  m_monster_type = monster::ennemy_monster;
  m_energy = s_sting_energy;
  m_offensive_force = s_sting_offensive_force;
  m_defensive_powers[normal_attack] = true;
  m_offensive_coefficients[indefensible_attack] = 1;
  set_mass(0);
} // sting::sting()

/*---------------------------------------------------------------------------*/
/**
 * \brief Initialise the item.
 */
void ptb::sting::start()
{
  set_model("model/sting.cm");
  execute_action("attack");
} // string::start()

/*---------------------------------------------------------------------------*/
/**
 * \brief Do one iteration in the progression of the item.
 * \param elapsed_time Elapsed time since the last call.
 */
void ptb::sting::progress( bear::universe::time_type elapsed_time )
{
  if ( m_is_dead )
    {
      bear::engine::world* w = get_owner();

      base_item* new_item = new bear::decorative_item;

      bear::visual::animation* anim =
        new bear::visual::animation( get_animation("explosion") );

      anim->set_loops(1);

      new_item->set_animation_field("animation", anim);
      new_item->set_real_field("pos_x",get_position().x);
      new_item->set_real_field("pos_y",get_position().y);
      new_item->set_real_field("angle",get_angle());
      new_item->set_bool_field("kill_when_finished", true);

      w->register_item( new_item );

      CLAW_ASSERT( new_item->is_valid(),
                   "The explosion of sting isn't correctly initialized" );
      new_item->start();

      kill();
    }
  else if ( has_contact() )
    m_is_dead = true;
  else
    super::progress( elapsed_time );
} // sting::progress()

/*----------------------------------------------------------------------------*/
/**
 * \brief The item has attacked.
 */
void ptb::sting::has_attacked()
{
  m_is_dead = true;
} // sting::has_attacked()

/*---------------------------------------------------------------------------*/
/**
 * \brief Inform the item tat he left the active region.
 */
void ptb::sting::left_active_region()
{
  kill();
} // sting::left_active_region()
