/*
  Plee The Bear

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file state_wasp.cpp
 * \brief Definition of the class describing a state of Wasp.
 * \author Sebastien Angibaud
 */
#ifndef __PTB_STATE_WASP_HPP__
#define __PTB_STATE_WASP_HPP__

#include <string>
#include "universe/types.hpp"
#include "universe/physical_item.hpp"

namespace ptb
{
  class wasp;

  /**
   * \brief The class describing a state of a wasp.
   * \author Sebastien Angibaud
   */
  class state_wasp
  {
  public:
    state_wasp(ptb::wasp* wasp_instance);
    virtual ~state_wasp() {};

  public:
    virtual std::string get_name() const { return "undefined state"; };
    virtual void start() {};
    virtual void progress( bear::universe::time_type elapsed_time );
    virtual void set_bottom_contact(bear::universe::physical_item_state& item);

  protected:
    /** \brief The instance of Wasp. */
    ptb::wasp* m_wasp_instance;

  }; // class state_wasp
} // namespace ptb

#include "ptb/item/wasp/wasp.hpp"

#endif // __PTB_STATE_WASP_HPP__





