/*
  Plee The Bear

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file wasp.hpp
 * \brief The class describing a wasp.
 * \author Sbastien Angibaud
 */
#ifndef __PTB_WASP_HPP__
#define __PTB_WASP_HPP__

#include "ptb/base_enemy.hpp"
#include "ptb/monster.hpp"
#include "engine/model.hpp"
#include "ptb/item/wasp/state_wasp.hpp"


namespace ptb
{
  /**
   * \brief The class describing a wasp.
   * \author Sbastien Angibaud
   * The parameters accepted by this item are:
   * The custom fields of this class are :
   *  - \a steps: number of steps in one passage.
   *  - \a translation_x: \c The x-coordonate translation,
   *  - \a translation_y: \c The y-coordonate translation.
   */
  class wasp :
    public base_enemy< bear::engine::model<bear::engine::base_item> >
  {
  public:
    enum wasp_state_name
      {
        fly_state = 0,
        attack_state,
        dead_state
      }; // enum wasp_state_name


    /** \brief The type of the parent class. */
    typedef base_enemy< bear::engine::model<bear::engine::base_item> > super;

    /** \brief Number of states considered. */
    static const unsigned int states_cardinality = 3;

    /** \brief  The number of sting in an offensive. */
    static const unsigned int s_nb_sting = 3; 

    /** \brief  The number of iteration in an offensive. */
    static const unsigned int s_offensive_time = 216;

    /** \brief  The number of iteration before the first attack. */
    static const unsigned int s_first_attack = 48;

    /** \brief  The size of the offensive. */
    static const unsigned int s_zone_offensive_width = 200;

    /** \brief  The width gap for the first sting. */
    static const unsigned int s_gap_width_1 = 35;

    /** \brief  The height gapfor the first sting. */
    static const unsigned int s_gap_height_1 = 82;

    /** \brief  The width gap for the second sting. */
    static const unsigned int s_gap_width_2 = 45;

    /** \brief  The height gapfor the second sting. */
    static const unsigned int s_gap_height_2 = 80;

    /** \brief  The width gap for the third sting. */
    static const unsigned int s_gap_width_3 = 59;

    /** \brief  The height gapfor the third sting. */
    static const unsigned int s_gap_height_3 = 77;

    /** \brief The oscillation angle in an iteration.*/
    static const unsigned int s_oscillation_angle = 10;

    /** \brief The offensive_force of a wasp.*/
    static const unsigned int s_wasp_offensive_force = 40;


  public:
    wasp();
    ~wasp();

    void start();
    void progress( bear::universe::time_type elapsed_time );

    bool set_real_field( const std::string& name, double value );
    bool set_u_integer_field( const std::string& name, unsigned int value );

    virtual bool is_valid() const;

    bear::universe::position_type get_first_target() const;
    bear::universe::position_type get_second_target() const;
    unsigned int get_number_of_steps() const;
    bool get_positive_orientation();
    void set_positive_orientation(bool orientation);
    void set_state(wasp_state_name state);
    void start_action_parent(const std::string action);

    virtual void inform_no_energy();
    virtual void set_bottom_contact(bear::universe::physical_item_state& item);

  private:
    /** \brief Indicates if the wasp is in an attack movement. */
    bool m_is_in_attack;

    /** \brief Indicates if the wasp have attacked in current way. */
    bool m_have_attacked;

    /** \brief Pointer to the first target. */
    bear::universe::position_type m_first_target;

    /** \brief Pointer to the second target. */
    bear::universe::position_type m_second_target;

    /** \brief The way of the wasp. */
    bear::universe::speed_type m_translation;

    /** \brief What the wasp is doing. */
    wasp_state_name m_current_state;

    //** \brief The different states of wasp. */
    std::vector< state_wasp* > m_states;

    /** \brief Indicates if wasp go to the right. */
    bool m_positive_orientation;

    /** \brief Indicates the number of steps in a transit. */
    unsigned int m_number_of_steps;
  }; // class wasp
} // namespace ptb

#endif // __PTB_WASP_HPP__
