/*
  Plee The Bear

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file balloon_layer.hpp
 * \brief The balloon layer contains all balloons.
 * \author Angibaud Sebastien
 */
#ifndef __PTB_BALLOON_LAYER_HPP__
#define __PTB_BALLOON_LAYER_HPP__

#include "ptb/speaker_item.hpp"
#include "engine/layer/gui_layer.hpp"
#include "communication/messageable.hpp"
#include "engine/camera.hpp"
#include <string>
#include <list>

namespace ptb
{
  /**
   * \brief The balloon layer contains the balloons of the text said by the
   *        items.
   */
  class balloon_layer:
    public bear::communication::messageable,
    public bear::engine::gui_layer
  {
  public:
    /*----------------------------------------------------------------------*/
    /**
     * \brief A message that add a speaker in the layer.
     * \author Sebastien Angibaud
     */
    class msg_add_speaker : public bear::communication::message
    {
    public:
      msg_add_speaker();
      void set_speaker( ptb::speaker_item* speaker );
      bool apply_to( bear::communication::messageable& that );
      
    private:
      /** \brief Pointer to the speaker. */
      ptb::speaker_item* m_speaker;
    }; // class msg_add_speaker

  
  public:
    balloon_layer();
    
    void progress( bear::universe::time_type elapsed_time );
    
    void render( bear::visual::screen& screen );

    bool add_speaker( ptb::speaker_item* speaker);

    static const std::string& default_name();
    
  private:
    void adjust_balloon_position(ptb::speaker_item*);
    void adjust_position_in_camera
    ( ptb::speaker_item*,  bear::engine::camera::msg_get_focus& msg_cam,
      bool& top, bool& right);

    void adjust_position( ptb::speaker_item*, 
                          bear::engine::camera::msg_get_focus& msg_cam,
                          bool& top, bool& right);
      
  private:
    /** \brief Default name of the balloon layer. */
    static const std::string s_default_name;

    /** \brief List of speakers. */
    std::list<ptb::speaker_item*> m_speakers;
    
    /** \brief  The size of the border. */
    static const unsigned int s_border;

  }; // class balloon_layer
} // namespace ptb

#endif // __PTB_BALLOON_LAYER_HPP__
