/*
  Plee The Bear

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file gui_layer.hpp
 * \brief The graphical user interface of the game.
 * \author Julien Jorge
 */
#ifndef __PTB_GUI_LAYER_HPP__
#define __PTB_GUI_LAYER_HPP__

#include "engine/layer/gui_layer.hpp"
#include "gui/static_text.hpp"
#include "time/time_reference.hpp"

#include <vector>

namespace ptb
{
  /**
   * \brief The graphical user interface of the game.
   *
   * This layer contains sub layers, for example:
   *
   *  - windows_layer,
   *  - status_layer,
   *  - speech_balloons_layer,
   *  - player_arrows_layer.
   *
   * \author Julien Jorge
   */
  class gui_layer:
    public bear::engine::gui_layer
  {
  public:
    gui_layer( const std::vector<bear::engine::gui_layer*>& layers );
    ~gui_layer();

    void start();
    void progress( bear::universe::time_type elapsed_time );
    void render( bear::visual::screen& screen );

    bool key_pressed( bear::input::keyboard::key_code key );
    bool button_pressed( bear::input::joystick::joy_code button,
                         unsigned int joy_index );
    bool mouse_pressed( bear::input::mouse::mouse_code key,
                        const claw::math::coordinate_2d<unsigned int>& pos );
    bool mouse_released( bear::input::mouse::mouse_code button,
                         const claw::math::coordinate_2d<unsigned int>& pos );
    bool mouse_maintained( bear::input::mouse::mouse_code button,
                           const claw::math::coordinate_2d<unsigned int>& pos );
    bool mouse_move( const claw::math::coordinate_2d<unsigned int>& pos );

  private:
    bool read_levelshot_key( bear::input::keyboard::key_code key );

    void screenshot() const;
    void levelshot() const;
    void render_fps( bear::visual::screen& screen );

  private:
    /** \brief The sub layers */
    std::vector<bear::engine::gui_layer*> m_sub_layers;

    /** \brief The component in which we show the numer of frames per second. */
    bear::gui::static_text m_fps_text;

    /** \brief The number of frames rendered in the current second. */
    unsigned int m_fps_count;

    /** \brief The number of iterations done in the current second. */
    unsigned int m_its_count;

    /** \brief Tell if we must show the number tof frames per second. */
    bool m_show_fps;

    /** \brief The ratio applied to the level size for the levelshot. */
    unsigned int m_levelshot_ratio;

    /** \brief The count of successive keys that concern the levelshot. */
    unsigned int m_levelshot_key_count;

    /** \brief The date of the last fps check. */
    bear::time_ref::time_reference m_last_fps_check;

    /** \brief The key to display the number of frames per second. */
    bear::input::keyboard::key_code m_fps_key;

    /** \brief The key to take a screenshot. */
    bear::input::keyboard::key_code m_screenshot_key;

    /** \brief The key to toggle fullscreen mode. */
    bear::input::keyboard::key_code m_fullscreen_key;

    /** \brief The key to take a picture of the whole level. */
    bear::input::keyboard::key_code m_level_map_key;

    /** \brief The key to turn on/off the frame limit. */
    bear::input::keyboard::key_code m_time_step_key;

  }; // class gui_layer
} // namespace ptb

#endif // __PTB_GUI_LAYER_HPP__
