/*
  Plee The Bear

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file level_starting_layer.hpp
 * \brief A layer that displays some informations at the begining of a level.
 * \author Julien Jorge
 */
#ifndef __PTB_LEVEL_STARTING_LAYER_HPP__
#define __PTB_LEVEL_STARTING_LAYER_HPP__

#include "engine/layer/gui_layer.hpp"
#include "gui/static_text.hpp"

namespace ptb
{
  /**
   * \brief A layer that displays some informations at the begining of a level.
   * \author Julien Jorge
   */
  class level_starting_layer:
    public bear::engine::gui_layer
  {
  public:
    level_starting_layer();
    ~level_starting_layer();

    void start();
    void progress( bear::universe::time_type elapsed_time );
    void render( bear::visual::screen& screen );

    bool key_pressed( bear::input::keyboard::key_code key );
    bool button_pressed( bear::input::joystick::joy_code button,
                         unsigned int joy_index );
    bool mouse_pressed( bear::input::mouse::mouse_code key,
                        const claw::math::coordinate_2d<unsigned int>& pos );
    bool mouse_released( bear::input::mouse::mouse_code button,
                         const claw::math::coordinate_2d<unsigned int>& pos );
    bool mouse_maintained( bear::input::mouse::mouse_code button,
                           const claw::math::coordinate_2d<unsigned int>& pos );
    bool mouse_move( const claw::math::coordinate_2d<unsigned int>& pos );

  private:
    /** \brief How long the layer stays visible. */
    const bear::universe::time_type m_visibility_duration;

    /** \brief The time before m_fill_color starts to fade. */
    const bear::universe::time_type m_fade_time;

    /** \brief Elapsed time since the layer was created. */
    bear::universe::time_type m_elapsed_time;

    /** \brief Tell if the layer is active or not. */
    bool m_active;

    /** \brief The name of the level. */
    bear::gui::static_text m_level_name;

    /** \brief The act of the level. */
    bear::gui::static_text m_act;

    /** \brief The color that fades on the level. */
    bear::visual::sprite m_fill_color;

    /** \brief The thumbnail of the level. */
    bear::visual::sprite* m_thumb;

    /** \brief The position of the thumbnail of the level. */
    const claw::math::coordinate_2d<int> m_thumb_position;

    /** \brief The maximum zoom of the thumbnail of the level. */
    const double m_thumb_zoom_max;

    /** \brief The zoom of the thumbnail of the level. */
    double m_thumb_zoom;

    /** \brief The directrion of the zoom of the thumbnail of the level. */
    double m_thumb_zoom_direction;

    /** \brief The angle of the thumbnail of the level. */
    double m_thumb_angle;

    /** \brief The strip behing the level name. */
    bear::visual::sprite m_strip;

    /** \brief The position of the strip. */
    claw::math::coordinate_2d<int> m_strip_position;

    /** \brief The name of the game. */
    bear::gui::static_text m_game_name;

  }; // class level_starting_layer
} // namespace ptb

#endif // __PTB_LEVEL_STARTING_LAYER_HPP__
