/*
  Plee The Bear

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file player_arrows_layer.hpp
 * \brief A player_arrows_layer is a layer containing the arrows of players.
 * \author Sebastien Angibaud
 */
#ifndef __PTB_PLAYER_ARROWS_LAYER_HPP__
#define __PTB_PLAYER_ARROWS_LAYER_HPP__

#include "engine/layer/gui_layer.hpp"
#include "engine/pointer_to_player.hpp"
#include "gui/static_text.hpp"

namespace ptb
{
  /**
   * \brief An player_arrows_layer is a layer containing the arrows of the
   *        players.
   * \author Sebastien Angibaud
   */
  class player_arrows_layer : public bear::engine::gui_layer
  {
  public:
    player_arrows_layer();
    ~player_arrows_layer();

    void render( bear::visual::screen& screen );

  private:
    claw::math::coordinate_2d<int>
    adjust_position
    ( const bear::universe::position_type& position_player,
      const bear::universe::rectangle_type& visible_area ) const;

    void adjust_distance
    ( double angle, const bear::universe::position_type& arrow_position,
      const bear::universe::position_type& position_player,
      const bear::universe::rectangle_type& visible_area );

    void render_player
    ( bear::visual::screen& screen,
      const bear::universe::rectangle_type& visible_area,
      const bear::engine::pointer_to_player& p, bear::visual::sprite* arrow );
    
    double adjust_angle
    ( const bear::universe::position_type& position_player,
      const bear::universe::position_type& position_arrow ) const;

  private:
    /** \brief Pointer to the sprites of arrows for the first player. */
    bear::visual::sprite* m_player_1_sprite;

    /** \brief Pointer to the sprites of arrows for the second player. */
    bear::visual::sprite* m_player_2_sprite;

    /** \brief Pointer to the first player. */
    bear::engine::pointer_to_player m_first_player;

    /** \brief Pointer to the second player. */
    bear::engine::pointer_to_player m_second_player;

    /** \brief The component in which we show the distance of the player. */
    bear::gui::static_text m_text;

  }; // class player_arrows_layer
} // namespace ptb

#endif // __PTB_PLAYER_ARROWS_LAYER_HPP__
