/*
  Plee The Bear

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file status_layer.hpp
 * \brief The status layer contains the area where are printed the score,
 *        energy, remaining lifes of the players.
 * \author Julien Jorge
 */
#ifndef __PTB_STATUS_LAYER_HPP__
#define __PTB_STATUS_LAYER_HPP__

#include "engine/layer/gui_layer.hpp"
#include "engine/pointer_to_player.hpp"
#include "gui/static_text.hpp"
#include "engine/font_factory.hpp"

namespace ptb
{
  /**
   * \brief The status layer contains the area where are printed the score,
   *        energy, remaining lifes of the players.
   */
  class status_layer:  
    public bear::engine::gui_layer
  {
  private:
    /**
     * \brief All the informations we want to show about a player.
     */
    class player_status
    {
    public:
      player_status();

      /** \brief Score. */
      unsigned int score;

      /** \brief Remaining lifes. */
      unsigned int lifes;

      /** \brief Number of energy. */
      unsigned int energy;

      /** \brief Number of stone. */
      unsigned int stones;
    }; // class player_status

  public:
    status_layer();
    virtual ~status_layer();

    void progress( bear::universe::time_type elapsed_time );

    void render( bear::visual::screen& screen );

  private:
    void render_player1( bear::visual::screen& screen, player_status status );
    void render_player2( bear::visual::screen& screen, player_status status );

    void progress_time( bear::universe::time_type elapsed_time );

  private:
    /** \brief Pointer to the first player. */
    bear::engine::pointer_to_player m_first_player;

    /** \brief Pointer to the second player. */
    bear::engine::pointer_to_player m_second_player;

    /** \brief First player's status. */
    player_status m_first_status;

    /** \brief Second player's status. */
    player_status m_second_status;
    
    /** \brief First font for time text. */
    claw::memory::smart_ptr<bear::text::font> m_font_1;

    /** \brief Second font for time text. */
    claw::memory::smart_ptr<bear::text::font> m_font_2;
    
    /** \brief The component in which we show the number of stone. */
    bear::gui::static_text m_text_stones;

    /** \brief The component in which we show the time. */
    bear::gui::static_text m_text_time;

    /** \brief Sprite for the energy. */
    bear::visual::sprite* m_sprite_energy;

    /** \brief Sprite for if the player have no energy. */
    bear::visual::sprite* m_sprite_no_energy;

    /** \brief Sprite of stone. */
    bear::visual::sprite* m_sprite_stone;

  }; // class status_layer
} // namespace ptb

#endif // __PTB_STATUS_LAYER_HPP__
