/*
  Plee The Bear

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file base_monster.hpp
 * \brief The class describing a monster (an item with energy).
 * \author Sbastien Angibaud
 */
#ifndef __PTB_MONSTER_ITEM_HPP__
#define __PTB_MONSTER_ITEM_HPP__

#include "ptb/monster.hpp"
#include "engine/base_item.hpp"

namespace ptb
{
  /**
   * \brief The class describing a monster (an item with energy).
   *
   * \b Template \b arguments :
   *  - \a Base the base class of the model, should be base_item,
   *       renderable_item, messageable_item or renderable_messageable.
   *
   * \author Sbastien Angibaud
   */
  template<class Base>
  class monster_item :
    public Base,
    public monster
  {
  public:
    /** \brief The type of the parent class. */
    typedef Base super;

  public:
    monster_item();
    monster_item( const std::string& model_file );

    virtual void progress( bear::universe::time_type elapsed_time );

  protected:
    void to_string( std::string& str ) const;

    void hit( bear::engine::base_item& that,
              const bear::universe::physical_item_state& old_self,
              const bear::universe::physical_item_state& old_that );


    virtual void remove_energy( unsigned int energy );
    virtual void inform_no_energy();

  private:
    /** \brief Transparency of injured frame. */
    double m_alpha_blend_injured;

    /** \brief Increment for the transparency when injured. */
    double m_alpha_blend_inc;

  }; // class monster_item
} // namespace ptb

#include "ptb/code/monster_item.tpp"

#endif // __PTB_MONSTER_ITEM_HPP__
