/*
  Plee The Bear

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file player_action.hpp
 * \brief Code values of the player's actions.
 * \author Julien Jorge
 */
#ifndef __PTB_PLAYER_ACTION_HPP__
#define __PTB_PLAYER_ACTION_HPP__

#include "engine/player.hpp"

namespace ptb
{
  /**
   * \brief Code values of the player's actions.
   * \author Julien Jorge
   */
  struct player_action
  {
    /** \brief Action code: Idle. */
    static const bear::engine::player::action idle =
      bear::engine::player::last_action_code_value + 1;

    /** \brief Action code: Move to the left. */
    static const bear::engine::player::action move_left = idle + 1;

    /** \brief Action code: Move to the right. */
    static const bear::engine::player::action move_right = move_left + 1;

    /** \brief Action code: Jump. */
    static const bear::engine::player::action jump = move_right + 1;

    /** \brief Action code: Look up. */
    static const bear::engine::player::action look_up = jump + 1;

    /** \brief Action code: Crouch. */
    static const bear::engine::player::action crouch = look_up + 1;

    /** \brief Action code: Slap. */
    static const bear::engine::player::action slap = crouch + 1;

    /** \brief Action code: Throw a stone. */
    static const bear::engine::player::action throw_stone = slap + 1;

    /** \brief Action code: Drop the current power up. */
    static const bear::engine::player::action drop = throw_stone + 1;

    /** \brief Action code: Speak to the other plee. */
    static const bear::engine::player::action speak = drop + 1;

    /** \brief Action code: Set the camera on the plee. */
    static const bear::engine::player::action get_camera = speak + 1;

    /** \brief Action code: Chain plee. */
    static const bear::engine::player::action chain = get_camera + 1;

     /** \brief Action code: Unhain plee. */
    static const bear::engine::player::action unchain = chain + 1;


  }; // struct player_action
} // namespace ptb

#endif // __PTB_PLAYER_ACTION_HPP__
