/*
    Plee The Bear - Big to texture

    Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by the
    Free Software Foundation; either version 2 of the License, or (at your
    option) any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
    more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

    contact: plee-the-bear@gamned.org

    Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file application.hpp
 * \brief The main class.
 * \author Julien Jorge
 */
#ifndef __APPLICATION_HPP__
#define __APPLICATION_HPP__

#include <claw/application.hpp>
#include <claw/image.hpp>
#include <claw/math.hpp>

#include <string>
#include <set>

/**
 * \brief The main class.
 *
 * The program accept the following parameters :
 * - --output The directory where the texture are saved,
 * - --script The script to read to create the textures,
 * - --image The source image, where we take the parts of the textures,
 * - --help Print help and exit.
 * \author Julien Jorge
 */
class application : public claw::application
{
public:
  application( int& argc, char** &argv );

  int run();

private:
  void help() const;
  void check_arguments( int& argc, char** &argv );

  void process_script( std::istream& is ) const;
  void process_file( const std::string& target_name, std::istream& is ) const;

  void
  copy_texture_parts( claw::graphic::image& texture, std::istream& is ) const;

  void save_image
  ( const claw::graphic::image& texture, const std::string& target_name ) const;

private:
  /** \brief Tell if we should quit immediatly. */
  bool m_quit;

  /** \brief The folder where we save the images. */
  std::string m_output_folder;

  /** \brief The script to read to create the textures. */
  std::string m_script;

  /** \brief The image from which we create the textures. */
  claw::graphic::image* m_image;

}; // class application

#endif // __APPLICATION_HPP__
