/*
  Plee the Bear

  Copyright (C) 2005-2009 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file game_variables.hpp
 * \brief The class that helps accessing to the game variables.
 * \author Julien Jorge
 */
#ifndef __PTB_GAME_VARIABLES_HPP__
#define __PTB_GAME_VARIABLES_HPP__

#include <string>

namespace ptb
{
  /**
   * \brief The class that helps accessing to the game variables.
   * \author Julien Jorge
   */
  class game_variables
  {
  public:
    static unsigned int get_players_count();
    static void set_players_count( unsigned int c );

    static std::string get_last_level_exit( unsigned int p );
    static void set_last_level_exit( unsigned int p, const std::string& e );

    static std::string get_next_level_name();
    static void set_next_level_name( const std::string& n );

    static std::string get_corrupting_bonus_animation_name();
    static void set_corrupting_bonus_animation_name( const std::string& n );

    static bool get_password_menu_visibility();
    static void set_password_menu_visibility( bool v );

    static bool get_friendly_fire();
    static void set_friendly_fire( bool v );

    static bool get_current_level_is_finished();
    static void set_current_level_is_finished( bool v );

    static unsigned int get_lives_count( unsigned int p);
    static void set_lives_count( unsigned int p, unsigned int c );

    static unsigned int get_stones_count( unsigned int p);
    static void set_stones_count( unsigned int p, unsigned int c );

    static double get_max_energy( unsigned int p);
    static void set_max_energy( unsigned int p, double v );

    static unsigned int get_score( unsigned int p );
    static void set_score( unsigned int p, unsigned int c );
    static void add_score( unsigned int p, unsigned int c );

    static bool get_air_power( unsigned int p );
    static void set_air_power( unsigned int p, bool v );
 
    static bool get_fire_power( unsigned int p );
    static void set_fire_power( unsigned int p, bool v );
    
    static bool get_water_power( unsigned int p );
    static void set_water_power( unsigned int p, bool v );

    static unsigned int get_corrupting_bonus_count();
    static void set_corrupting_bonus_count( unsigned int c );

    static std::string
    make_player_specific_variable_name( unsigned int p, const std::string& n );

  }; // class game_variables
} // namespace ptb

#endif // __PTB_GAME_VARIABLES_HPP__
