/*
  Bear Engine

  Copyright (C) 2005-2010 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file camera_shaker.hpp
 * \brief An item that shakes the camera.
 * \author Sebastien Angibaud
 */
#ifndef __BEAR_CAMERA_SHAKER_HPP__
#define __BEAR_CAMERA_SHAKER_HPP__

#include "engine/base_item.hpp"
#include "engine/item_brick/item_with_toggle.hpp"
#include "engine/export.hpp"
#include "generic_items/class_export.hpp"

namespace bear
{
  /**
   * \brief An item that shakes the camera.
   *
   * The valid fields for this item are
   *  - \a shaker_force: (real) force of the shaker (default = 10),
   *  - any field supported by the parent classes.
   *
   * \author Sebastien Angiabud
   */
  class GENERIC_ITEMS_EXPORT camera_shaker:
    public engine::item_with_toggle<engine::base_item>
  {
    DECLARE_BASE_ITEM(camera_shaker);

  public:
    typedef engine::item_with_toggle<engine::base_item> super;

  public:
    camera_shaker();

    bool set_real_field( const std::string& name, double value );
    void set_shaker_force(double force);

    void progress_on( universe::time_type elapsed_time );

  private:
    /** \brief The force of the agitation. */
    double m_shaker_force;
  }; // class camera_shaker
} // namespace bear

#endif // __BEAR_CAMERA_SHAKER_HPP__
