/*
  Bear Engine

  Copyright (C) 2005-2010 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file forced_translation_creator.hpp
 * \brief This class creates a forced movement of type "forced_translation",
 *        applies it to itself then die.
 * \author Julien Jorge
 */
#ifndef __BEAR_FORCED_TRANSLATION_CREATOR_HPP__
#define __BEAR_FORCED_TRANSLATION_CREATOR_HPP__

#include "engine/base_item.hpp"
#include "universe/forced_movement/forced_translation.hpp"

#include "engine/export.hpp"
#include "generic_items/class_export.hpp"

namespace bear
{
  /**
   * \brief This class creates a forced movement of type "forced_translation",
   *        applies it to itself then die.
   *
   * The fields of this item are
   *  - \a slant: (real) \c the angle applied to the item (default = 0),
   *  - \a force_angle: (bool) \c tell (true) if we apply the \a angle as is or
   *    (false) if \a angle is added to the angle of the item
   *    (default = false),
   *  - \a duration: (real) \c the total time of the movement (default = inf.),
   *  - \a speed_x: (real) \c the speed of the movement on the X axis
   *    (default = 0),
   *  - \a speed_y: (real) \c the speed of the movement on the Y axis
   *    (default = 0).
   *
   * \author Julien Jorge
   */
  class GENERIC_ITEMS_EXPORT forced_translation_creator:
    public engine::base_item
  {
    DECLARE_BASE_ITEM(forced_translation_creator);

  public:
    /** \brief The type of the parent class. */
    typedef engine::base_item super;

  public:
    bool set_real_field( const std::string& name, double value );
    bool set_bool_field( const std::string& name, bool value );

    void build();

  private:
    /** \brief The movement finally applied. */
    universe::forced_translation m_movement;

  }; // class forced_translation_creator
} // namespace bear

#endif // __BEAR_FORCED_TRANSLATION_CREATOR_HPP__
