/*
 *  plex86: run multiple x86 operating systems concurrently
 *  Copyright (C) 1999-2001 Kevin P. Lawton
 *
 *  io_pro.c: IO protection mechanisms.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */

#include "plex86.h"
#include "monitor.h"


  void
IOPermCheck(vm_t *vm, Bit32u port, unsigned len)
{
  if ( vm->guest_cpu.cr0.fields.pe &&
       (vm->guest_cpu.veflags.fields.vm ||
        (G_CPL(vm) > G_GetIOPL(vm))) ) {
    Bit16u io_base, permission16;
    unsigned bit_index, i;
 
    if ( (vm->guest_cpu.tr_cache.valid==0) ||
         (vm->guest_cpu.tr_cache.desc.type!=9) ) {
      monpanic(vm, "IOPermCheck: TR not valid 32bit TSS\n");
      goto no_permission;
      }
 
    if (vm->guest_cpu.tr_cache.limit_scaled < 103) {
      monpanic(vm, "IOPermCheck: TR.limit < 103\n");
      }
 
    access_linear(vm, vm->guest_cpu.tr_cache.base + 102, 2, 0, OP_READ,
                  &io_base);

    if (io_base <= 103) {
      monpanic(vm, "IOPermCheck: TR:io_base <= 103\n");
      }
 
    if (io_base > vm->guest_cpu.tr_cache.limit_scaled) {
      monprint(vm, "IOPermCheck: CPL > IOPL: no IO bitmap defined #GP(0)\n");
      goto no_permission;
      }
 
    access_linear(vm, vm->guest_cpu.tr_cache.base + io_base + port/8,
                  2, 0, OP_READ, &permission16);
 
    bit_index = port & 0x07;
    permission16 >>= bit_index;
    for (i=0; i<len; i++) {
      if (permission16 & 0x01)
        goto no_permission;
      permission16 >>= 1;
      }
    }
  return;

no_permission:
  exception(vm, ExceptionGP, 0);
}
