/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.components.io.attributes.PlexusIoResourceAttributeUtils;
import org.codehaus.plexus.components.io.attributes.PlexusIoResourceAttributes;
import org.codehaus.plexus.components.io.resources.PlexusIoFileResource;
import org.codehaus.plexus.components.io.resources.PlexusIoResource;
import org.codehaus.plexus.components.io.resources.PlexusIoResourceWithAttributes;

public class ArchiveEntry {
    public static final String ROLE = ArchiveEntry.class.getName();
    public static final int FILE = 1;
    public static final int DIRECTORY = 2;
    private PlexusIoResource resource;
    private String name;
    private int type;
    private int mode;
    private PlexusIoResourceAttributes attributes;

    private ArchiveEntry(String name, PlexusIoResource resource, int type, int mode) {
        this.name = name;
        this.resource = resource;
        this.attributes = resource instanceof PlexusIoResourceWithAttributes ? ((PlexusIoResourceWithAttributes)resource).getAttributes() : null;
        this.type = type;
        int permissions = mode;
        if (mode == -1 && this.attributes == null) {
            int n = permissions = resource.isFile() ? 33188 : 16877;
        }
        this.mode = permissions == -1 ? permissions : permissions & 0xFFF | (type == 1 ? 32768 : 16384);
    }

    public String getName() {
        return this.name;
    }

    public File getFile() {
        if (this.resource instanceof PlexusIoFileResource) {
            return ((PlexusIoFileResource)this.resource).getFile();
        }
        return null;
    }

    public InputStream getInputStream() throws IOException {
        return this.resource.getContents();
    }

    public int getType() {
        return this.type;
    }

    public int getMode() {
        if (this.mode != -1) {
            return this.mode;
        }
        if (this.attributes != null && this.attributes.getOctalMode() > -1) {
            return this.attributes.getOctalMode();
        }
        return (this.type == 1 ? 33188 : 16877) & 0xFFF | (this.type == 1 ? 32768 : 16384);
    }

    public static ArchiveEntry createFileEntry(String target, PlexusIoResource resource, int permissions) throws ArchiverException {
        if (resource.isDirectory()) {
            throw new ArchiverException("Not a file: " + resource.getName());
        }
        return new ArchiveEntry(target, resource, 1, permissions);
    }

    public static ArchiveEntry createFileEntry(String target, File file, int permissions) throws ArchiverException {
        PlexusIoResourceAttributes attrs;
        if (!file.isFile()) {
            throw new ArchiverException("Not a file: " + file);
        }
        try {
            attrs = PlexusIoResourceAttributeUtils.getFileAttributes((File)file);
        }
        catch (IOException e) {
            throw new ArchiverException("Failed to read filesystem attributes for: " + file, e);
        }
        PlexusIoFileResource res = PlexusIoFileResource.existingFile((File)file, (PlexusIoResourceAttributes)attrs);
        return new ArchiveEntry(target, (PlexusIoResource)res, 1, permissions);
    }

    public static ArchiveEntry createDirectoryEntry(String target, PlexusIoResource resource, int permissions) throws ArchiverException {
        if (!resource.isDirectory()) {
            throw new ArchiverException("Not a directory: " + resource.getName());
        }
        return new ArchiveEntry(target, resource, 2, permissions);
    }

    public static ArchiveEntry createDirectoryEntry(String target, File file, int permissions) throws ArchiverException {
        PlexusIoResourceAttributes attrs;
        if (!file.isDirectory()) {
            throw new ArchiverException("Not a directory: " + file);
        }
        try {
            attrs = PlexusIoResourceAttributeUtils.getFileAttributes((File)file);
        }
        catch (IOException e) {
            throw new ArchiverException("Failed to read filesystem attributes for: " + file, e);
        }
        PlexusIoFileResource res = new PlexusIoFileResource(file, attrs);
        return new ArchiveEntry(target, (PlexusIoResource)res, 2, permissions);
    }

    public static ArchiveEntry createEntry(String target, File file, int filePerm, int dirPerm) throws ArchiverException {
        if (file.isDirectory()) {
            return ArchiveEntry.createDirectoryEntry(target, file, dirPerm);
        }
        if (file.isFile()) {
            return ArchiveEntry.createFileEntry(target, file, filePerm);
        }
        throw new ArchiverException("Neither a file nor a directory: " + file);
    }

    public PlexusIoResourceAttributes getResourceAttributes() {
        return this.attributes;
    }

    public void setResourceAttributes(PlexusIoResourceAttributes attributes) {
        this.attributes = attributes;
    }

    public PlexusIoResource getResource() {
        return this.resource;
    }
}

