from plone.openid.tests.oitestcase import FunctionalOpenIdTestCase
from zExceptions import Redirect


class TestOpenIdAuthentication(FunctionalOpenIdTestCase):

    def buildServerResponse(self):
        credentials={}
        for field in [ "nonce", "openid.assoc_handle", "openid.return_to",
                        "openid.signed", "openid.sig",
                        "openid.invalidate_handle", "openid.mode"]:
            credentials[field]=field
        credentials["openid.identity"]=self.identity
        credentials["openid.source"]="server"

        return credentials


    def testEmptyAuthentication(self):
        """Test if we do not invent an identity out of thin air.
        """
        creds=self.folder.pas.openid.authenticateCredentials({})
        self.assertEqual(creds, None)

    def testEmptyStringIdentityAuthentication(self):
        """Test coverage for bug #7176, where an 
           "" (i.e. an empty string) identity passed to 
           authenticationCredentials should return fail authentication
        """
        credentials=self.buildServerResponse()
        credentials["openid.identity"]=""
        creds=self.folder.pas.openid.authenticateCredentials(credentials)
        self.assertEqual(creds, None)

    def testUnknownOpenIdSource(self):
        """Test if an incorrect source does not produce unexpected exceptions.
        """
        creds=self.folder.pas.openid.authenticateCredentials({"openid.source" : "x"})
        self.assertEqual(creds, None)


    def testServerAuthentication(self):
        """Test authentication of OpenID server responses.
        """
        credentials=self.buildServerResponse()
        creds=self.folder.pas.openid.authenticateCredentials(credentials)
        self.assertEqual(creds, (self.identity, self.identity))


    def testIncompleteServerAuthentication(self):
        """Test authentication of OpenID server responses.
        """
        credentials=self.buildServerResponse()
        del credentials["openid.sig"]
        creds=self.folder.pas.openid.authenticateCredentials(credentials)
        self.assertEqual(creds, None)


def test_suite():
    from unittest import TestSuite, makeSuite
    suite=TestSuite()
    suite.addTest(makeSuite(TestOpenIdAuthentication))
    return suite
