#!/bin/sh
# Test suite for octave examples.
#
# Copyright (C) 2004  Alan W. Irwin
# Copyright (C) 2004  Rafael Laboissiere
#
# This file is part of PLplot.
#
# PLplot is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Library Public License as published
# by the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# PLplot is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU Library General Public License
# along with PLplot; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

# This is called from plplot-test.sh with $octave, $octavedir, $device,
# $dsuffix and $options defined.
# Assumes that $option starts and are '-' separated.

# The following is only need for the build tree!  It should has no effect
# when this script is launched from the install tree.
TOPDIR=`pwd`/..
export LD_LIBRARY_PATH=$TOPDIR/src/.libs:$TOPDIR/lib/csa/.libs:$TOPDIR/lib/nn/.libs

# Launch an Octave script that exercises all the demos
$octave -f -q -p $octavedir <<EOF
plplot_stub;
t = split("$options", "-"); t(1,:)="";
for i=1:rows(t)
    tt = deblank (t(i,:)); len = length(tt);
    ix = index(tt," ");
    if (ix == 0); ix = len; len = 0; endif
    plsetopt(tt(1:ix), tt(ix:len));
endfor

# p7 works OK with plmeta, e.g., but not ps or psc. pleop/plbop issue?
# These require octave-2.1.50 so comment out since not everybody has
# this.

for i=[1:7 8 9 13 15 16];
   figure(i,"$device",sprintf("p%d.$dsuffix",i));
   feval(sprintf("p%d",i))
   closefig
endfor

#plot equivalent of x??c examples.  These only required octave-2.0.x
#For file output 14 and 17 are not suitable, and 19 is not done
#(and should probably be dropped anyway since the map stuff is not
#in the API that is supposed to be common to all front ends.)
failed = [];
for i=[1:13 15 16 18];
    cmd = sprintf("x%.2dc",i);
    t = split("$options", "-"); t(1,:)="";
    for j=1:rows(t)
        tt = deblank (t(j,:)); len = length(tt);
	ix = index(tt," ");
	if (ix == 0); ix = len; len = 0; endif
	plSetOpt(deblank(tt(1:ix)), tt(ix:len));
    endfor
    device="$device";
    plSetOpt("dev", device);
#o trailer on filename e.g., x01o.ps) to distinguish from other
#common examples.
    file = sprintf("x%.2do.$dsuffix",i);
    plSetOpt("o", file);
    eval(cmd, "failed = [failed, i];");
endfor
if ! isempty (failed)
    printf ("Failed tests: ");
    for i = 1 : length (failed)
        if i != 1
            printf (", ");
        endif
        printf ("x%.2dc.m", failed (i));
    endfor
    printf ("\n");
    exit (1);
endif
EOF
