/*
  This file is part of PLplot.
  
  PLplot is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Library Public License as published
  by the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  PLplot is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.
  
  You should have received a copy of the GNU Library General Public License
  along with PLplot; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
  
  
  This header file contains the lookup tables used for converting between
  hershey and unicode. It is an automatically generated file, so please do
  not edit it directly. Make any changes to plhershey-unicode.csv, then use
  plhershey-unicode-gen.c to recreate this header file.
  
  plhershey-unicode.csv consists of three fields: the first field is the
  hershey code, and is in decimal; the second is the unicode value, and is
  in hex; and the final field is font index. There are five possible font
  indices:
       0        undefined/unknown
       1        normal
       2        roman
       3        italic-roman
       4        script
  
  Font indices are used for approximating the appearence of the original
  hershey glyphs.
  
  Unicode values of 0x0000 signify unknowns.
  
*/
const int number_of_entries_in_hershey_to_unicode_table=979;

typedef struct {
	unsigned int Hershey;
	PLUNICODE Unicode;
	char Font;
} Hershey_to_Unicode_table;

const Hershey_to_Unicode_table hershey_to_unicode_lookup_table[979] = {
{1,0x0041,1}, {2,0x0042,1}, {3,0x0043,1}, {4,0x0044,1}, 
{5,0x0045,1}, {6,0x0046,1}, {7,0x0047,1}, {8,0x0048,1}, 
{9,0x0049,1}, {10,0x004a,1}, {11,0x004b,1}, {12,0x004c,1}, 
{13,0x004d,1}, {14,0x004e,1}, {15,0x004f,1}, {16,0x0050,1}, 
{17,0x0051,1}, {18,0x0052,1}, {19,0x0053,1}, {20,0x0054,1}, 
{21,0x0055,1}, {22,0x0056,1}, {23,0x0057,1}, {24,0x0058,1}, 
{25,0x0059,1}, {26,0x005a,1}, {27,0x0391,1}, {28,0x0392,1}, 
{29,0x0393,1}, {30,0x0394,1}, {31,0x0395,1}, {32,0x0396,1}, 
{33,0x0397,1}, {34,0x0398,1}, {35,0x0399,1}, {36,0x039a,1}, 
{37,0x039b,1}, {38,0x039c,1}, {39,0x039d,1}, {40,0x039e,1}, 
{41,0x039f,1}, {42,0x03a0,1}, {43,0x03a1,1}, {44,0x03a3,1}, 
{45,0x03a4,1}, {46,0x03a5,1}, {47,0x03a6,1}, {48,0x03a7,1}, 
{49,0x03a8,1}, {50,0x03a9,1}, {200,0x0030,1}, {201,0x0031,1}, 
{202,0x0032,1}, {203,0x0033,1}, {204,0x0034,1}, {205,0x0035,1}, 
{206,0x0036,1}, {207,0x0037,1}, {208,0x0038,1}, {209,0x0039,1}, 
{210,0x002e,1}, {211,0x002c,1}, {212,0x003a,1}, {213,0x003b,1}, 
{214,0x0021,1}, {215,0x003f,1}, {216,0x0027,1}, {217,0x0022,1}, 
{218,0x00b0,1}, {219,0x0024,1}, {220,0x002f,1}, {221,0x0028,1}, 
{222,0x0029,1}, {223,0x007c,1}, {224,0x002d,1}, {225,0x002b,1}, 
{226,0x003d,1}, {227,0x00d7,1}, {228,0x2217,1}, {229,0x22c5,1}, 
{230,0x2018,1}, {231,0x2019,1}, {232,0x2192,1}, {233,0x0023,1}, 
{234,0x0026,1}, {235,0x0000,1}, {236,0x0040,1}, {238,0x2025,0}, 
{239,0x2025,0}, {240,0x0000,0}, {242,0x0000,0}, {248,0x2248,0}, 
{250,0x2245,0}, {252,0x21cc,0}, {261,0x00bd,2}, {262,0x2153,2}, 
{263,0x2159,2}, {264,0x215b,2}, {265,0x2154,2}, {266,0x215c,2}, 
{267,0x215d,2}, {268,0x215e,2}, {269,0x215a,2}, {270,0x00bc,2}, 
{271,0x00be,2}, {272,0x00a3,2}, {273,0x00ae,2}, {274,0x00a9,2}, 
{275,0x2262,0}, {276,0x22ef,0}, {278,0x2194,0}, {279,0x2195,0}, 
{280,0x0000,0}, {281,0x0000,0}, {282,0x220b,0}, {284,0x2980,0}, 
{501,0x0041,1}, {502,0x0042,1}, {503,0x0043,1}, {504,0x0044,1}, 
{505,0x0045,1}, {506,0x0046,1}, {507,0x0047,1}, {508,0x0048,1}, 
{509,0x0049,1}, {510,0x004a,1}, {511,0x004b,1}, {512,0x004c,1}, 
{513,0x004d,1}, {514,0x004e,1}, {515,0x004f,1}, {516,0x0050,1}, 
{517,0x0051,1}, {518,0x0052,1}, {519,0x0053,1}, {520,0x0054,1}, 
{521,0x0055,1}, {522,0x0056,1}, {523,0x0057,1}, {524,0x0058,1}, 
{525,0x0059,1}, {526,0x005a,1}, {527,0x0391,1}, {528,0x0392,1}, 
{529,0x0393,1}, {530,0x0394,1}, {531,0x0395,1}, {532,0x0396,1}, 
{533,0x0397,1}, {534,0x0398,1}, {535,0x0399,1}, {536,0x039a,1}, 
{537,0x039b,1}, {538,0x039c,1}, {539,0x039d,1}, {540,0x039e,1}, 
{541,0x039f,1}, {542,0x03a0,1}, {543,0x03a1,1}, {544,0x03a3,1}, 
{545,0x03a4,1}, {546,0x03a5,1}, {547,0x03a6,1}, {548,0x03a7,1}, 
{549,0x03a8,1}, {550,0x03a9,1}, {551,0x0041,4}, {552,0x0042,4}, 
{553,0x0043,4}, {554,0x0044,4}, {555,0x0045,4}, {556,0x0046,4}, 
{557,0x0047,4}, {558,0x0048,4}, {559,0x0049,4}, {560,0x004a,4}, 
{561,0x004b,4}, {562,0x004c,4}, {563,0x004d,4}, {564,0x004e,4}, 
{565,0x004f,4}, {566,0x0050,4}, {567,0x0051,4}, {568,0x0052,4}, 
{569,0x0053,4}, {570,0x0054,4}, {571,0x0055,4}, {572,0x0056,4}, 
{573,0x0057,4}, {574,0x0058,4}, {575,0x0059,4}, {576,0x005a,4}, 
{583,0x2207,1}, {601,0x0061,1}, {602,0x0062,1}, {603,0x0063,1}, 
{604,0x0064,1}, {605,0x0065,1}, {606,0x0066,1}, {607,0x0067,1}, 
{608,0x0068,1}, {609,0x0069,1}, {610,0x006a,1}, {611,0x006b,1}, 
{612,0x006c,1}, {613,0x006d,1}, {614,0x006e,1}, {615,0x006f,1}, 
{616,0x0070,1}, {617,0x0071,1}, {618,0x0072,1}, {619,0x0073,1}, 
{620,0x0074,1}, {621,0x0075,1}, {622,0x0076,1}, {623,0x0077,1}, 
{624,0x0078,1}, {625,0x0079,1}, {626,0x007a,1}, {627,0x03b1,4}, 
{628,0x03b2,4}, {629,0x03b3,4}, {630,0x03b4,4}, {631,0x03b5,4}, 
{632,0x03b6,4}, {633,0x03b7,4}, {634,0x03b8,4}, {635,0x03b9,4}, 
{636,0x03ba,4}, {637,0x03bb,4}, {638,0x03bc,4}, {639,0x03bd,4}, 
{640,0x03be,4}, {641,0x03bf,4}, {642,0x03c0,4}, {643,0x03c1,4}, 
{644,0x03c3,4}, {645,0x03c4,4}, {646,0x03c5,4}, {647,0x03c6,4}, 
{648,0x03c7,4}, {649,0x03c8,4}, {650,0x03c9,4}, {651,0x0061,4}, 
{652,0x0062,4}, {653,0x0063,4}, {654,0x0064,4}, {655,0x0065,4}, 
{656,0x0066,4}, {657,0x0067,4}, {658,0x0068,4}, {659,0x0069,4}, 
{660,0x006a,4}, {661,0x006b,4}, {662,0x006c,4}, {663,0x006d,4}, 
{664,0x006e,4}, {665,0x006f,4}, {666,0x0070,4}, {667,0x0071,4}, 
{668,0x0072,4}, {669,0x0073,4}, {670,0x0074,4}, {671,0x0075,4}, 
{672,0x0076,4}, {673,0x0077,4}, {674,0x0078,4}, {675,0x0079,4}, 
{676,0x007a,4}, {677,0x2113,4}, {683,0x2202,4}, {684,0x03f5,4}, 
{685,0x03f4,4}, {686,0x03d5,4}, {687,0x03c2,4}, {700,0x0030,1}, 
{701,0x0031,1}, {702,0x0032,1}, {703,0x0033,1}, {704,0x0034,1}, 
{705,0x0035,1}, {706,0x0036,1}, {707,0x0037,1}, {708,0x0038,1}, 
{709,0x0039,1}, {710,0x002e,1}, {711,0x002c,1}, {712,0x003a,1}, 
{713,0x003b,1}, {714,0x0021,1}, {715,0x003f,1}, {716,0x0027,1}, 
{717,0x0022,1}, {718,0x00b0,1}, {719,0x0024,1}, {720,0x002f,1}, 
{721,0x0028,1}, {722,0x0029,1}, {723,0x007c,1}, {724,0x002d,1}, 
{725,0x002b,1}, {726,0x003d,1}, {727,0x00d7,1}, {728,0x2217,1}, 
{729,0x22c5,1}, {730,0x2018,1}, {731,0x2019,1}, {732,0x2192,1}, 
{733,0x0023,1}, {734,0x0026,1}, {735,0x0000,1}, {736,0x0020,1}, 
{737,0x2225,1}, {738,0x22a5,1}, {739,0x2220,1}, {740,0x2234,1}, 
{741,0x2664,1}, {742,0x2661,1}, {743,0x2662,1}, {744,0x2667,1}, 
{745,0x0000,1}, {746,0x0000,1}, {750,0x0000,0}, {751,0x0000,0}, 
{752,0x0000,0}, {753,0x25b4,0}, {754,0x0000,0}, {755,0x0000,0}, 
{756,0x0000,0}, {757,0x0000,0}, {758,0x25e0,0}, {759,0x0000,0}, 
{760,0x0000,0}, {761,0x0000,0}, {762,0x0000,0}, {763,0x0000,0}, 
{764,0x0000,0}, {765,0x223e,0}, {766,0x221e,0}, {767,0x2608,0}, 
{768,0x00a7,0}, {796,0x257c,0}, {797,0x2571,0}, {798,0x257d,0}, 
{799,0x2572,0}, {800,0x0000,0}, {801,0x0000,0}, {802,0x0000,0}, 
{803,0x0000,0}, {804,0x0000,0}, {805,0x0000,0}, {806,0x0000,0}, 
{807,0x0000,0}, {808,0x0000,0}, {809,0x0000,0}, {810,0x25dc,0}, 
{811,0x25df,0}, {812,0x25de,0}, {813,0x25dd,0}, {814,0x0000,0}, 
{815,0x0000,0}, {816,0x0000,0}, {817,0x0000,0}, {818,0x0000,0}, 
{819,0x223f,0}, {820,0x0000,0}, {821,0x0000,0}, {822,0x0000,0}, 
{823,0x221d,0}, {824,0x0000,0}, {825,0x0000,0}, {826,0x0000,0}, 
{827,0x0000,0}, {828,0x22c5,0}, {829,0x0000,0}, {830,0x0000,0}, 
{831,0x0000,0}, {832,0x0000,0}, {833,0x0000,0}, {834,0x0000,0}, 
{840,0x25cb,0}, {841,0x25a1,0}, {842,0x25b3,0}, {843,0x2662,0}, 
{844,0x2729,0}, {845,0x002b,1}, {846,0x00d7,1}, {847,0x2217,1}, 
{850,0x2219,0}, {851,0x25a0,0}, {852,0x25b2,0}, {853,0x25c0,0}, 
{854,0x25bc,0}, {855,0x25b6,0}, {856,0x22c6,0}, {857,0x21be,0}, 
{860,0x0000,0}, {861,0x0000,0}, {862,0x0000,0}, {863,0x0000,0}, 
{864,0x0000,0}, {865,0x0000,0}, {866,0x0000,0}, {867,0x263e,0}, 
{868,0x2721,0}, {869,0x0000,0}, {870,0x0000,0}, {871,0x0000,0}, 
{872,0x0000,0}, {873,0x0000,0}, {874,0x0000,0}, {900,0x0000,0}, 
{901,0x0000,0}, {902,0x0000,0}, {903,0x0000,0}, {904,0x0000,0}, 
{905,0x0000,0}, {906,0x0000,0}, {907,0x0000,0}, {908,0x0000,0}, 
{909,0x0000,0}, {910,0x0000,0}, {911,0x0000,0}, {2001,0x0041,2}, 
{2002,0x0042,2}, {2003,0x0043,2}, {2004,0x0044,2}, {2005,0x0045,2}, 
{2006,0x0046,2}, {2007,0x0047,2}, {2008,0x0048,2}, {2009,0x0049,2}, 
{2010,0x004a,2}, {2011,0x004b,2}, {2012,0x004c,2}, {2013,0x004d,2}, 
{2014,0x004e,2}, {2015,0x004f,2}, {2016,0x0050,2}, {2017,0x0051,2}, 
{2018,0x0052,2}, {2019,0x0053,2}, {2020,0x0054,2}, {2021,0x0055,2}, 
{2022,0x0056,2}, {2023,0x0057,2}, {2024,0x0058,2}, {2025,0x0059,2}, 
{2026,0x005a,2}, {2027,0x0391,2}, {2028,0x0392,2}, {2029,0x0393,2}, 
{2030,0x0394,2}, {2031,0x0395,2}, {2032,0x0396,2}, {2033,0x0397,2}, 
{2034,0x0398,2}, {2035,0x0399,2}, {2036,0x039a,2}, {2037,0x039b,2}, 
{2038,0x039c,2}, {2039,0x039d,2}, {2040,0x039e,2}, {2041,0x039f,2}, 
{2042,0x03a0,2}, {2043,0x03a1,2}, {2044,0x03a3,2}, {2045,0x03a4,2}, 
{2046,0x03a5,2}, {2047,0x03a6,2}, {2048,0x03a7,2}, {2049,0x03a8,2}, 
{2050,0x03a9,2}, {2051,0x0041,3}, {2052,0x0042,3}, {2053,0x0043,3}, 
{2054,0x0044,3}, {2055,0x0045,3}, {2056,0x0046,3}, {2057,0x0047,3}, 
{2058,0x0048,3}, {2059,0x0049,3}, {2060,0x004a,3}, {2061,0x004b,3}, 
{2062,0x004c,3}, {2063,0x004d,3}, {2064,0x004e,3}, {2065,0x004f,3}, 
{2066,0x0050,3}, {2067,0x0051,3}, {2068,0x0052,3}, {2069,0x0053,3}, 
{2070,0x0054,3}, {2071,0x0055,3}, {2072,0x0056,3}, {2073,0x0057,3}, 
{2074,0x0058,3}, {2075,0x0059,3}, {2076,0x005a,3}, {2077,0x03f0,3}, 
{2101,0x0061,2}, {2102,0x0062,2}, {2103,0x0063,2}, {2104,0x0064,2}, 
{2105,0x0065,2}, {2106,0x0066,2}, {2107,0x0067,2}, {2108,0x0068,2}, 
{2109,0x0069,2}, {2110,0x006a,2}, {2111,0x006b,2}, {2112,0x006c,2}, 
{2113,0x006d,2}, {2114,0x006e,2}, {2115,0x006f,2}, {2116,0x0070,2}, 
{2117,0x0071,2}, {2118,0x0072,2}, {2119,0x0073,2}, {2120,0x0074,2}, 
{2121,0x0075,2}, {2122,0x0076,2}, {2123,0x0077,2}, {2124,0x0078,2}, 
{2125,0x0079,2}, {2126,0x007a,2}, {2127,0x03b1,3}, {2128,0x03b2,3}, 
{2129,0x03b3,3}, {2130,0x03b4,3}, {2131,0x03b5,3}, {2132,0x03b6,3}, 
{2133,0x03b7,3}, {2134,0x03b8,3}, {2135,0x03b9,3}, {2136,0x03ba,3}, 
{2137,0x03bb,3}, {2138,0x03bc,3}, {2139,0x03bd,3}, {2140,0x03be,3}, 
{2141,0x03bf,3}, {2142,0x03c0,3}, {2143,0x03c1,3}, {2144,0x03c3,3}, 
{2145,0x03c4,3}, {2146,0x03c5,3}, {2147,0x03c6,3}, {2148,0x03c7,3}, 
{2149,0x03c8,3}, {2150,0x03c9,3}, {2151,0x0061,3}, {2152,0x0062,3}, 
{2153,0x0063,3}, {2154,0x0064,3}, {2155,0x0065,3}, {2156,0x0066,3}, 
{2157,0x0067,3}, {2158,0x0068,3}, {2159,0x0069,3}, {2160,0x006a,3}, 
{2161,0x006b,3}, {2162,0x006c,3}, {2163,0x006d,3}, {2164,0x006e,3}, 
{2165,0x006f,3}, {2166,0x0070,3}, {2167,0x0071,3}, {2168,0x0072,3}, 
{2169,0x0073,3}, {2170,0x0074,3}, {2171,0x0075,3}, {2172,0x0076,3}, 
{2173,0x0077,3}, {2174,0x0078,3}, {2175,0x0079,3}, {2176,0x007a,3}, 
{2177,0x0000,0}, {2178,0xfb01,2}, {2179,0xfb02,2}, {2180,0x0000,0}, 
{2181,0x0000,0}, {2182,0x0000,0}, {2184,0x03f5,0}, {2185,0x03f4,0}, 
{2186,0x03d5,0}, {2187,0x03c2,0}, {2190,0x0000,0}, {2191,0x0000,0}, 
{2192,0xfb01,3}, {2193,0xfb02,3}, {2194,0x0000,0}, {2195,0x0000,0}, 
{2196,0x0000,0}, {2200,0x0030,2}, {2201,0x0031,2}, {2202,0x0032,2}, 
{2203,0x0033,2}, {2204,0x0034,2}, {2205,0x0035,2}, {2206,0x0036,2}, 
{2207,0x0037,2}, {2208,0x0038,2}, {2209,0x0039,2}, {2210,0x002e,2}, 
{2211,0x002c,2}, {2212,0x003a,2}, {2213,0x003b,2}, {2214,0x0021,2}, 
{2215,0x003f,2}, {2216,0x0027,2}, {2217,0x0022,2}, {2218,0x00b0,2}, 
{2219,0x002a,2}, {2220,0x002f,2}, {2221,0x0028,2}, {2222,0x0029,2}, 
{2223,0x005b,2}, {2224,0x005d,2}, {2225,0x007b,2}, {2226,0x007d,2}, 
{2227,0x2329,2}, {2228,0x232a,2}, {2229,0x007c,2}, {2230,0x2225,0}, 
{2231,0x2212,0}, {2232,0x002b,0}, {2233,0x0000,0}, {2234,0x2213,0}, 
{2235,0x0000,0}, {2236,0x0000,0}, {2237,0x00f7,0}, {2238,0x0000,0}, 
{2239,0x2260,0}, {2240,0x2261,0}, {2241,0x003c,0}, {2242,0x003e,0}, 
{2243,0x2266,0}, {2244,0x2267,0}, {2245,0x221d,0}, {2246,0x223e,0}, 
{2247,0x0000,0}, {2248,0x0000,0}, {2249,0x0000,0}, {2250,0x0000,0}, 
{2251,0x0000,0}, {2252,0x0000,0}, {2253,0x0000,0}, {2254,0x0000,0}, 
{2255,0x221a,0}, {2256,0x2282,0}, {2257,0x22c3,0}, {2258,0x2283,0}, 
{2259,0x22c2,0}, {2260,0x220a,0}, {2261,0x2192,0}, {2262,0x2191,0}, 
{2263,0x2190,0}, {2264,0x2193,0}, {2265,0x2202,0}, {2266,0x2207,0}, 
{2267,0x221a,0}, {2268,0x222b,0}, {2269,0x222e,0}, {2270,0x221e,0}, 
{2271,0x0025,0}, {2272,0x0026,0}, {2273,0x0040,0}, {2274,0x0024,0}, 
{2275,0x0023,0}, {2276,0x00a7,0}, {2277,0x2020,0}, {2278,0x2021,0}, 
{2279,0x2203,0}, {2281,0x2299,0}, {2282,0x263f,0}, {2283,0x2640,0}, 
{2284,0x2641,0}, {2285,0x2642,0}, {2286,0x2643,0}, {2287,0x2644,0}, 
{2288,0x2645,0}, {2289,0x2646,0}, {2290,0x2647,0}, {2291,0x263e,0}, 
{2292,0x2604,0}, {2293,0x2605,0}, {2294,0x260a,0}, {2295,0x260b,0}, 
{2296,0x2197,0}, {2297,0x2199,0}, {2298,0x2196,0}, {2299,0x2198,0}, 
{2301,0x2648,0}, {2302,0x2649,0}, {2303,0x264a,0}, {2304,0x264b,0}, 
{2305,0x260a,0}, {2306,0x264d,0}, {2307,0x264e,0}, {2308,0x264f,0}, 
{2309,0x2650,0}, {2310,0x2651,0}, {2311,0x2652,0}, {2312,0x2653,0}, 
{2317,0x0000,0}, {2318,0x0000,0}, {2319,0x0000,0}, {2320,0x0000,0}, 
{2321,0x0000,0}, {2322,0x0000,0}, {2323,0x266f,0}, {2324,0x266e,0}, 
{2325,0x266d,0}, {2326,0x0000,0}, {2327,0x0000,0}, {2328,0x0000,0}, 
{2329,0x0000,0}, {2330,0x0000,0}, {2331,0x0000,0}, {2332,0x0000,0}, 
{2363,0x0000,0}, {2364,0x0000,0}, {2365,0x0000,0}, {2367,0x0000,0}, 
{2368,0x0000,0}, {2369,0x0000,0}, {2370,0x0000,0}, {2371,0x0000,0}, 
{2372,0x0000,0}, {2373,0x266f,0}, {2374,0x266e,0}, {2375,0x266d,0}, 
{2376,0x0000,0}, {2377,0x0000,0}, {2378,0x0000,0}, {2379,0x0000,0}, 
{2380,0x0000,0}, {2381,0x0000,0}, {2382,0x0000,0}, {2401,0x220f,0}, 
{2402,0x2211,0}, {2403,0x0000,0}, {2404,0x0000,0}, {2405,0x0000,0}, 
{2406,0x0000,0}, {2407,0x0000,0}, {2408,0x0000,0}, {2409,0x0000,0}, 
{2410,0x0000,0}, {2411,0x221a,0}, {2412,0x222b,0}, {2501,0x0041,1}, 
{2502,0x0042,1}, {2503,0x0043,1}, {2504,0x0044,1}, {2505,0x0045,1}, 
{2506,0x0046,1}, {2507,0x0047,1}, {2508,0x0048,1}, {2509,0x0049,1}, 
{2510,0x004a,1}, {2511,0x004b,1}, {2512,0x004c,1}, {2513,0x004d,1}, 
{2514,0x004e,1}, {2515,0x004f,1}, {2516,0x0050,1}, {2517,0x0051,1}, 
{2518,0x0052,1}, {2519,0x0053,1}, {2520,0x0054,1}, {2521,0x0055,1}, 
{2522,0x0056,1}, {2523,0x0057,1}, {2524,0x0058,1}, {2525,0x0059,1}, 
{2526,0x005a,1}, {2551,0x0041,4}, {2552,0x0042,4}, {2553,0x0043,4}, 
{2554,0x0044,4}, {2555,0x0045,4}, {2556,0x0046,4}, {2557,0x0047,4}, 
{2558,0x0048,4}, {2559,0x0049,4}, {2560,0x004a,4}, {2561,0x004b,4}, 
{2562,0x004c,4}, {2563,0x004d,4}, {2564,0x004e,4}, {2565,0x004f,4}, 
{2566,0x0050,4}, {2567,0x0051,4}, {2568,0x0052,4}, {2569,0x0053,4}, 
{2570,0x0054,4}, {2571,0x0055,4}, {2572,0x0056,4}, {2573,0x0057,4}, 
{2574,0x0058,4}, {2575,0x0059,4}, {2576,0x005a,4}, {2601,0x0061,1}, 
{2602,0x0062,1}, {2603,0x0063,1}, {2604,0x0064,1}, {2605,0x0065,1}, 
{2606,0x0066,1}, {2607,0x0067,1}, {2608,0x0068,1}, {2609,0x0069,1}, 
{2610,0x006a,1}, {2611,0x006b,1}, {2612,0x006c,1}, {2613,0x006d,1}, 
{2614,0x006e,1}, {2615,0x006f,1}, {2616,0x0070,1}, {2617,0x0071,1}, 
{2618,0x0072,1}, {2619,0x0073,1}, {2620,0x0074,1}, {2621,0x0075,1}, 
{2622,0x0076,1}, {2623,0x0077,1}, {2624,0x0078,1}, {2625,0x0079,1}, 
{2626,0x007a,1}, {2628,0x0000,1}, {2651,0x0061,4}, {2652,0x0062,4}, 
{2653,0x0063,4}, {2654,0x0064,4}, {2655,0x0065,4}, {2656,0x0066,4}, 
{2657,0x0067,4}, {2658,0x0068,4}, {2659,0x0069,4}, {2660,0x006a,4}, 
{2661,0x006b,4}, {2662,0x006c,4}, {2663,0x006d,4}, {2664,0x006e,4}, 
{2665,0x006f,4}, {2666,0x0070,4}, {2667,0x0071,4}, {2668,0x0072,4}, 
{2669,0x0073,4}, {2670,0x0074,4}, {2671,0x0075,4}, {2672,0x0076,4}, 
{2673,0x0077,4}, {2674,0x0078,4}, {2675,0x0079,4}, {2676,0x007a,4}, 
{2700,0x0030,1}, {2701,0x0031,1}, {2702,0x0032,1}, {2703,0x0033,1}, 
{2704,0x0034,1}, {2705,0x0035,1}, {2706,0x0036,1}, {2707,0x0037,1}, 
{2708,0x0038,1}, {2709,0x0039,1}, {2710,0x002e,1}, {2711,0x002c,1}, 
{2712,0x003a,1}, {2713,0x003b,1}, {2714,0x0021,1}, {2715,0x003f,1}, 
{2716,0x2018,1}, {2717,0x2019,1}, {2718,0x0026,1}, {2719,0x0024,1}, 
{2720,0x002f,1}, {2721,0x0028,1}, {2722,0x0029,1}, {2723,0x002a,1}, 
{2724,0x002d,1}, {2725,0x002b,1}, {2726,0x003d,1}, {2726,0x0027,1}, 
{2729,0x0000,1}, {2750,0x0030,3}, {2751,0x0031,3}, {2752,0x0032,3}, 
{2753,0x0033,3}, {2754,0x0034,3}, {2755,0x0035,3}, {2756,0x0036,3}, 
{2757,0x0037,3}, {2758,0x0038,3}, {2759,0x0039,3}, {2760,0x002e,3}, 
{2761,0x002c,3}, {2762,0x003a,3}, {2763,0x003b,3}, {2764,0x0021,3}, 
{2765,0x003f,3}, {2766,0x0000,3}, {2767,0x0000,3}, {2768,0x0026,3}, 
{2769,0x0024,3}, {2770,0x002f,3}, {2771,0x0028,3}, {2772,0x0029,3}, 
{2773,0x002a,3}, {2774,0x002d,3}, {2775,0x002b,3}, {2776,0x003d,3}, 
{2777,0x0027,3}, {2778,0x0022,3}, {2779,0x0000,3}, {2801,0x0410,2}, 
{2802,0x0411,2}, {2803,0x0412,2}, {2804,0x0413,2}, {2805,0x0414,2}, 
{2806,0x0415,2}, {2807,0x0416,2}, {2808,0x0417,2}, {2809,0x0418,2}, 
{2810,0x0419,2}, {2811,0x041a,2}, {2812,0x041b,2}, {2813,0x041c,2}, 
{2814,0x041d,2}, {2815,0x041e,2}, {2816,0x041f,2}, {2817,0x0420,2}, 
{2818,0x0421,2}, {2819,0x0422,2}, {2820,0x0423,2}, {2821,0x0424,2}, 
{2822,0x0425,2}, {2823,0x0426,2}, {2824,0x0427,2}, {2825,0x0428,2}, 
{2826,0x0429,2}, {2827,0x042a,2}, {2828,0x042b,2}, {2829,0x042c,2}, 
{2830,0x042d,2}, {2831,0x042e,2}, {2832,0x042f,2}, {2901,0x0430,2}, 
{2902,0x0431,2}, {2903,0x0432,2}, {2904,0x0433,2}, {2905,0x0434,2}, 
{2906,0x0435,2}, {2907,0x0436,2}, {2908,0x0437,2}, {2909,0x0438,2}, 
{2910,0x0439,2}, {2911,0x043a,2}, {2912,0x043b,2}, {2913,0x043c,2}, 
{2914,0x043d,2}, {2915,0x043e,2}, {2916,0x043f,2}, {2917,0x0440,2}, 
{2918,0x0441,2}, {2919,0x0442,2}, {2920,0x0443,2}, {2921,0x0444,2}, 
{2922,0x0445,2}, {2923,0x0446,2}, {2924,0x0447,2}, {2925,0x0448,2}, 
{2926,0x0449,2}, {2927,0x044a,2}, {2928,0x044b,2}, {2929,0x044c,2}, 
{2930,0x044d,2}, {2931,0x044e,2}, {2932,0x044f,2}
};
