/*
 * ntoh.c - Network to host and host to network conversions.
 *
 * This file is part of the Portable.NET C library.
 * Copyright (C) 2004  Southern Storm Software, Pty Ltd.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <netinet/in.h>

__using__ System::Net::IPAddress;

uint32_t
ntohl (uint32_t netlong)
{
  return (uint32_t)IPAddress::NetworkToHostOrder ((int)netlong);
}

uint16_t
ntohs (uint16_t netshort)
{
  return (uint16_t)IPAddress::NetworkToHostOrder ((short)netshort);
}

uint32_t
htonl (uint32_t hostlong)
{
  return (uint32_t)IPAddress::HostToNetworkOrder ((int)hostlong);
}

uint16_t
htons (uint16_t hostshort)
{
  return (uint16_t)IPAddress::HostToNetworkOrder ((short)hostshort);
}
