#include <stdlib.h>
#include <stdio.h>
#include <wchar.h>
#include <string.h>
#include <setjmp.h>

#include "sys/wcebase.h"
#include "sys/wcetrace.h"
#include "sys/io.h"

//////////////////////////////////////////////////////////////////////

#if 0
#define MAXEXITFUNCS 20

typedef void (*PEXITFUNC)(void);

static PEXITFUNC exittab[MAXEXITFUNCS];
static int nexits;

// Code in import wrapper stores pr here. r12 points to it.
long _prstack[10];
long *_prstackp = &_prstack[9];
#endif

//////////////////////////////////////////////////////////////////////

static jmp_buf exitjmp;
static int exitcode;

//////////////////////////////////////////////////////////////////////

void
abort(void)
{
  longjmp(exitjmp, 1);
}

int
_exit(int code)
{
  exitcode = code;

  longjmp(exitjmp, 1);
}

void _parse_tokens(Char * string, Char * tokens[], Int * length);

/*
 * The current thinking here is that we will set up this default environment
 * block.  WCESYS can override this by setting the `environ' pointer to the 
 * shared memory segment it manages
 */

#define ENV_LEN     (64)
char *__env[ENV_LEN];
char **environ = __env;

#define CMDLINE_LEN (1024)
#define ARGV_LEN    (96)
#define NAME_LEN    (64)
char __cmdlinebuf[CMDLINE_LEN];
char *__argv[ARGV_LEN];


int
_startup()
{
  wchar_t *cmdlinePtrW;
  wchar_t  cmdnameBufW[NAME_LEN];
  char     cmdnameBuf[NAME_LEN];
  char    *ptr;
  int      cmdlineLen;
  int      argc = 0;
  int      len = 0;
  
  WCETRACESET(WCE_IO);
  _initfds();
  _initstdio();

  /* Initialize environment block */
  memset(__env, 0, sizeof(char *) * ENV_LEN);

  WCETRACE(WCE_IO, "WCETRACE initialized");

  /* Command line args processing */
  memset(__cmdlinebuf, 0, CMDLINE_LEN);
  
  /* argv[0] is the path of invoked program - get this from CE */
  len = GetModuleFileNameW(NULL, cmdnameBufW, NAME_LEN);
  wcstombs(cmdnameBuf, cmdnameBufW, wcslen(cmdnameBufW) + 1);
  __argv[0] = cmdnameBuf;

  cmdlinePtrW = GetCommandLineW();
  if (cmdlinePtrW != NULL && (cmdlineLen = wcslen(cmdlinePtrW)) > 0) {
    wcstombs(__cmdlinebuf, cmdlinePtrW, wcslen(cmdlinePtrW) + 1);
    WCETRACE(WCE_IO, "command line: \"%s\"", __cmdlinebuf);
    argc = ARGV_LEN - 1;
    _parse_tokens(__cmdlinebuf, &__argv[1], &argc);
    /* Add one to account for argv[0] */
    argc++;
  }

  if(setjmp(exitjmp) == 0)
    exitcode = main(argc, __argv);

#if 0
  _do_exit();
#endif
  return exitcode;
}

void
_parse_tokens(Char * string, Char * tokens[], Int * length) 
/*-------------------------------------------------------------------------*
 * Extract whitespace- and quotes- delimited tokens from the given string
 * and put them into the tokens array. Set *length to the number of tokens
 * extracted. On entry, *length must specify the size of tokens[].
 * THIS METHOD MODIFIES string.
 *-------------------------------------------------------------------------*/
{
  Char *  whitespace = " \t";
  Char *  tokenEnd;
  Char *  quoteCharacters = "\"\'";
  Int     numQuotes = strlen(quoteCharacters);
  Int     quoteIndex;
  Char    quote;
  Int     index = 0;

  if (string != NULL) {
    while (index < *length) {
       /* Skip over initial whitespace */
      string += strspn(string, whitespace);
      if (strlen(string) == 0) break;
      quoteIndex = numQuotes;
      while (--quoteIndex >= 0) if (*string == quoteCharacters[quoteIndex]) break;
      if (quoteIndex >= 0) {
         /* Token is quoted */
        quote = *string++;
        tokenEnd = strchr(string, quote);
         /* If there is no endquote, the token is the rest of the string */
        if (tokenEnd == NULL) tokenEnd = string + strlen(string);
      } else {
        tokenEnd = string + strcspn(string, whitespace);
      }
      tokens[index++] = string;
      if (*tokenEnd == '\0') break;
      *tokenEnd = '\0';
      string = tokenEnd + 1;
    }
  }
  *length = index;
}
