//
// DocumentType.cpp
//
// $Id: //poco/1.2/XML/src/DocumentType.cpp#1 $
//
// Library: XML
// Package: DOM
// Module:  DOM
//
// Copyright (c) 2004-2006, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#include "Poco/DOM/DocumentType.h"
#include "Poco/DOM/Document.h"
#include "Poco/DOM/DTDMap.h"
#include "Poco/DOM/DOMException.h"


namespace Poco {
namespace XML {


DocumentType::DocumentType(Document* pOwner, const XMLString& name, const XMLString& publicId, const XMLString& systemId): 
	AbstractContainerNode(pOwner),
	_name(name),
	_publicId(publicId),
	_systemId(systemId)
{
}


DocumentType::DocumentType(Document* pOwner, const DocumentType& doctype): 
	AbstractContainerNode(pOwner, doctype),
	_name(doctype._name),
	_publicId(doctype._publicId),
	_systemId(doctype._systemId)
{
}


DocumentType::~DocumentType()
{
}


NamedNodeMap* DocumentType::entities() const
{
	return new DTDMap(this, Node::ENTITY_NODE);
}


NamedNodeMap* DocumentType::notations() const
{
	return new DTDMap(this, Node::NOTATION_NODE);
}


const XMLString& DocumentType::nodeName() const
{
	return _name;
}


unsigned short DocumentType::nodeType() const
{
	return Node::DOCUMENT_TYPE_NODE;
}


const XMLString& DocumentType::internalSubset() const
{
	return EMPTY_STRING;
}


Node* DocumentType::copyNode(bool deep, Document* pOwnerDocument) const
{
	return new DocumentType(pOwnerDocument, *this);
}


} } // namespace Poco::XML
