# --------------------------------------------------------------------------- #
# $Id: metapost.py,v 1.5 2004/01/01 21:59:16 pandr Exp $
# --------------------------------------------------------------------------- #
#
# This file contains a bunch of hacks that demonstrate how you can try
# to integrate support for your favorite tool into pointless. There is NOT 
# much error checking at the moment. The aim was merely to demonstrate how to
# integrate support for external tools.
#
# The integration of a given tool <foo> can be split into four sections, the
# register_foo section, the write_foo section, the run_foo section and
# the _foo section. The register_foo is used to registre the command
# into the PLL language. The _foo function is the one that will be
# called as part of the parsing of the pll-input whenever a =foo (or a
# =begin-foo ... =end-foo section is detected. Finally, the write_foo 
# and run_foo functions are auxilary functions for the _foo function. 
# The write_foo is used to modify the input with additinon commands
# required for the run and the run_foo is finally used to run the
# external foo application.
#

from pllshared import *
import os
import re
import pllmodules 
import eps
import tex

_minmpostscale = 0.00001
_maxmpostscale = 100000.0

pll = None

def register():
	mpost = pll.add_command("mpost", _mpost, transform=1, vars=1)
	mpost.set_attrs({'scale':3.0})

def write_mpost_file(filename, content):
	f = open(filename, 'w')
	f.write(content)
	f.close()

def write_mposttex_file(filename):
	metaout = re.sub("\.tex$",".1",filename)
	f = open(filename, 'w')
	f.write("\\input epsf\n")
	f.write("\\nopagenumbers\n")
	f.write("$$\\centerline{\\epsfbox{"+metaout+"}}$$\n")
	f.write("\\bye\n")
	f.close()

def run_mpost(filename):
	olddir = os.getcwd()
	path = os.path.dirname(filename)
	file = os.path.basename(filename)
	os.chdir(path)
	mpost = pllmodules.find_program("mpost")
	errormsg = ""
	if mpost:
		failed = os.system("%s --tex=latex %s" % (mpost, filename))
	else:
		errormsg = "Unable to find the mpost program";
		failed = 1
	os.chdir(olddir)
	return not failed, errormsg

def _mpost(args, text, vars):
	scale = vars['scale']
	if not scale or scale < _minmpostscale or scale > _maxmpostscale:
		errmsg = "mpost must be in the interval (%f,%f)" % (_minmpostscale, _maxmpostscale)
		raise PllCommandError(errmsg)

	filename = pll.get_tempfilename()
	texfile = filename+".tex"
	epsfile = filename+".eps"
	mpostfile = filename+".mp"
	dvifile = filename+".dvi"
	pngfile = filename+".png"

	write_mposttex_file(texfile)

	oldmd5 = pllmodules.md5_file(mpostfile)
	write_mpost_file(mpostfile,text)
	newmd5 = pllmodules.md5_file(mpostfile)

	if oldmd5 != newmd5 or not os.path.isfile(pngfile):
		## content in mpostfile has changed
		ok, error = run_mpost(mpostfile)
		if not ok:
			os.unlink(mpostfile) # to purge cache
			errmsg = "Error running mpost on '%s'.\n" % text
			errmsg += error
			raise PllCommandError(errmsg)
		ok, error = tex.run_tex(texfile)
		if not ok:
			os.unlink(mpostfile) # to purge cache
			errmsg = "Error running TeX on '%s'.\n" % texfile
			errmsg += error
			raise PllCommandError(errmsg)
		ok, error = tex.run_dvips(dvifile, epsfile)
		if not ok:
			os.unlink(mpostfile) # to purge cache
			errmsg = "Error running dvips on '%s'.\n" % dvifile
			errmsg += error
			raise PllCommandError(errmsg)

	ok, error = eps.eps2png(epsfile, pngfile, scale*pll.scale)
	if not ok:
		os.unlink(mpostfile) # to purge cache
		errmsg = "Error converting eps '%s'.\n" % epsfile
		errmsg += error
		raise PllCommandError(errmsg)

	return '=gaimage("%s")' % pngfile

# --------------------------------------------------------------------------- #

