-- -*-sql-*- 
--
-- Copyright (C) 2004, 2005, 2006 Mekensleep
--
-- Mekensleep
-- 24 rue vieille du temple
-- 75004 Paris
--       licensing@mekensleep.com
--
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301, USA.
--
-- Authors:
--  Loic Dachary <loic@gnu.org>
--
DROP TABLE IF EXISTS server;

CREATE TABLE server (
  version VARCHAR(16) NOT NULL
) ENGINE=InnoDB CHARSET=utf8;

INSERT INTO server (version) VALUES ("1.0.32");

DROP TABLE IF EXISTS users;

CREATE TABLE users (
  serial INT UNSIGNED NOT NULL AUTO_INCREMENT,
  created INT UNSIGNED NOT NULL,
  name VARCHAR(32),
  email VARCHAR(128),
  affiliate INT UNSIGNED DEFAULT 0,
  skin_url VARCHAR(32) DEFAULT "random",
  skin_outfit TEXT,
  skin_image TEXT,
  skin_image_type VARCHAR(32) DEFAULT "image/png",
  password VARCHAR(32),
  privilege INT DEFAULT 1,

  rating INT DEFAULT 1000,
  future_rating FLOAT DEFAULT 1000,
  games_count INT DEFAULT 0,
  
  PRIMARY KEY (serial),
  UNIQUE KEY name_idx (name),
  UNIQUE KEY email_idx (email)
) ENGINE=InnoDB CHARSET=utf8;

DROP TABLE IF EXISTS users_private;

CREATE TABLE users_private (
  serial INT UNSIGNED NOT NULL,
  firstname VARCHAR(255) DEFAULT "",
  lastname VARCHAR(255) DEFAULT "",
  addr_street VARCHAR(255) DEFAULT "",
  addr_street2 VARCHAR(255) DEFAULT "",
  addr_zip VARCHAR(64) DEFAULT "",
  addr_town VARCHAR(64) DEFAULT "",
  addr_state VARCHAR(128) DEFAULT "",
  addr_country VARCHAR(64) DEFAULT "",
  phone VARCHAR(64) DEFAULT "",
  verified CHAR DEFAULT 'n',
  verified_time INT DEFAULT 0,

  PRIMARY KEY (serial)
) ENGINE=InnoDB CHARSET=utf8;

DROP TABLE IF EXISTS user2money;

CREATE TABLE user2money (
  user_serial INT UNSIGNED NOT NULL,
  currency_serial INT UNSIGNED NOT NULL,
  amount BIGINT NOT NULL,
  rake BIGINT DEFAULT 0 NOT NULL,
  points BIGINT DEFAULT 0 NOT NULL,

  PRIMARY KEY (user_serial,currency_serial)
)  ENGINE=InnoDB CHARSET=utf8;

DROP TABLE IF EXISTS currencies;

CREATE TABLE currencies (
  serial INT NOT NULL AUTO_INCREMENT UNIQUE,
  url CHAR(255) NOT NULL UNIQUE,
  symbol CHAR(8),
  name CHAR(32),
  cash_out INT,

  PRIMARY KEY (serial, url)
)  ENGINE=InnoDB CHARSET=utf8;

DROP TABLE IF EXISTS safe;

CREATE TABLE safe (
  currency_serial INT NOT NULL,
  serial INT NOT NULL,
  name CHAR(40) NOT NULL,
  value BIGINT NOT NULL,

  PRIMARY KEY (currency_serial, serial, value)
)  ENGINE=InnoDB CHARSET=utf8;

DROP TABLE IF EXISTS counter;

CREATE TABLE counter (
  transaction_id CHAR(40) NOT NULL,
  user_serial INT NOT NULL,
  currency_serial INT NOT NULL,
  serial INT NOT NULL,
  name CHAR(40) NOT NULL,
  value BIGINT NOT NULL,
  status CHAR DEFAULT 'y' NOT NULL,
  application_data VARCHAR(255) DEFAULT '' NOT NULL,

  PRIMARY KEY (currency_serial, name, serial)
)  ENGINE=InnoDB CHARSET=utf8;

DROP TABLE IF EXISTS user2table;

CREATE TABLE user2table (
  user_serial INT UNSIGNED NOT NULL,
  table_serial INT UNSIGNED NOT NULL,
  money INT DEFAULT 0 NOT NULL,
  bet INT DEFAULT 0 NOT NULL,

  PRIMARY KEY (user_serial,table_serial)
)  ENGINE=InnoDB CHARSET=utf8;

DROP TABLE IF EXISTS pokertables;

CREATE TABLE pokertables (
  serial INT UNSIGNED NOT NULL AUTO_INCREMENT,
  name VARCHAR(32),
  currency_serial INT NOT NULL,

  PRIMARY KEY (serial)
)  ENGINE=InnoDB CHARSET=utf8;

DROP TABLE IF EXISTS hands;

CREATE TABLE hands (
  serial INT UNSIGNED NOT NULL AUTO_INCREMENT,
  created TIMESTAMP NOT NULL,
  name VARCHAR(32),
  description TEXT NOT NULL,

  PRIMARY KEY (serial)
)  ENGINE=InnoDB CHARSET=utf8;

DROP TABLE IF EXISTS user2hand;

CREATE TABLE user2hand (
  user_serial INT NOT NULL,
  hand_serial INT NOT NULL,

  PRIMARY KEY (user_serial, hand_serial)
)  ENGINE=InnoDB CHARSET=utf8;

DROP TABLE IF EXISTS session;

CREATE TABLE session (
  user_serial INT NOT NULL,
  started INT DEFAULT 0,
  ended INT DEFAULT 0,
  ip VARCHAR(16),

  PRIMARY KEY (user_serial, ip)
)  ENGINE=InnoDB CHARSET=utf8;

DROP TABLE IF EXISTS session_history;

CREATE TABLE session_history (
  user_serial INT NOT NULL,
  started INT DEFAULT 0,
  ended INT DEFAULT 0,
  ip VARCHAR(16),

  KEY session_history_serial (user_serial)
)  ENGINE=InnoDB CHARSET=utf8;

DROP TABLE IF EXISTS tourneys_schedule;

CREATE TABLE tourneys_schedule (
  serial INT UNSIGNED NOT NULL AUTO_INCREMENT,
  name VARCHAR(32),
  description_short VARCHAR(64),
  description_long TEXT,
  players_quota INT DEFAULT 10,
  variant VARCHAR(32),
  betting_structure VARCHAR(32),
  seats_per_game INT DEFAULT 10,
  currency_serial INT,
  buy_in INT,
  rake INT,
  sit_n_go CHAR DEFAULT 'y',
  breaks_interval INT DEFAULT 60,
  rebuy_delay INT DEFAULT 0,
  add_on INT DEFAULT 0,
  add_on_delay INT DEFAULT 60,
  start_time INT DEFAULT 0,

  register_time INT DEFAULT 0,
  respawn CHAR DEFAULT 'n',
  respawn_interval INT DEFAULT 0,

  PRIMARY KEY (serial)
)  ENGINE=InnoDB CHARSET=utf8;

--
-- Holdem sit and go
--
INSERT INTO `tourneys_schedule` ( `name`, `description_short` , `description_long` , `players_quota` , `variant` , `betting_structure` , `seats_per_game` , `currency_serial` , `buy_in` , `rake` , `sit_n_go` , `start_time` , `register_time` , `respawn` , `respawn_interval` )
VALUES ( 'sitngo2', 'Sit and Go 2 players, Holdem', 'Sit and Go 2 players', '2', 'holdem', 'level-15-30-no-limit', '2', 1, '300000', '0', 'y', '0', '0', 'y', '0' );

INSERT INTO `tourneys_schedule` ( `name`, `description_short` , `description_long` , `players_quota` , `variant` , `betting_structure` , `seats_per_game` , `currency_serial` , `buy_in` , `rake` , `sit_n_go` , `start_time` , `register_time` , `respawn` , `respawn_interval` )
VALUES ( 'sitngo3', 'Sit and Go 3 players, Holdem', 'Sit and Go 3 players', '3', 'holdem', 'level-15-30-no-limit', '3', 1, '300000', '0', 'y', '0', '0', 'y', '0' );

INSERT INTO `tourneys_schedule` ( `name`, `description_short` , `description_long` , `players_quota` , `variant` , `betting_structure` , `seats_per_game` , `currency_serial` , `buy_in` , `rake` , `sit_n_go` , `start_time` , `register_time` , `respawn` , `respawn_interval` )
VALUES ( 'sitngo4', 'Sit and Go 4 players, Holdem', 'Sit and Go 4 players', '4', 'holdem', 'level-15-30-no-limit', '4', 1, '300000', '0', 'y', '0', '0', 'y', '0' );

INSERT INTO `tourneys_schedule` ( `name`, `description_short` , `description_long` , `players_quota` , `variant` , `betting_structure` , `seats_per_game` , `currency_serial` , `buy_in` , `rake` , `sit_n_go` , `start_time` , `register_time` , `respawn` , `respawn_interval` )
VALUES ( 'sitngo5', 'Sit and Go 5 players, Holdem', 'Sit and Go 5 players', '5', 'holdem', 'level-15-30-no-limit', '5', 1, '300000', '0', 'y', '0', '0', 'y', '0' );

INSERT INTO `tourneys_schedule` ( `name`, `description_short` , `description_long` , `players_quota` , `variant` , `betting_structure` , `seats_per_game` , `currency_serial` , `buy_in` , `rake` , `sit_n_go` , `start_time` , `register_time` , `respawn` , `respawn_interval` )
VALUES ( 'sitngo6', 'Sit and Go 6 players, Holdem', 'Sit and Go 6 players', '6', 'holdem', 'level-15-30-no-limit', '6', 1, '300000', '0', 'y', '0', '0', 'y', '0' );

INSERT INTO `tourneys_schedule` ( `name`, `description_short` , `description_long` , `players_quota` , `variant` , `betting_structure` , `seats_per_game` , `currency_serial` , `buy_in` , `rake` , `sit_n_go` , `start_time` , `register_time` , `respawn` , `respawn_interval` )
VALUES ( 'sitngo7', 'Sit and Go 7 players, Holdem', 'Sit and Go 7 players', '7', 'holdem', 'level-15-30-no-limit', '7', 1, '300000', '0', 'y', '0', '0', 'y', '0' );

INSERT INTO `tourneys_schedule` ( `name`, `description_short` , `description_long` , `players_quota` , `variant` , `betting_structure` , `seats_per_game` , `currency_serial` , `buy_in` , `rake` , `sit_n_go` , `start_time` , `register_time` , `respawn` , `respawn_interval` )
VALUES ( 'sitngo8', 'Sit and Go 8 players, Holdem', 'Sit and Go 8 players', '8', 'holdem', 'level-15-30-no-limit', '8', 1, '300000', '0', 'y', '0', '0', 'y', '0' );

INSERT INTO `tourneys_schedule` ( `name`, `description_short` , `description_long` , `players_quota` , `variant` , `betting_structure` , `seats_per_game` , `currency_serial` , `buy_in` , `rake` , `sit_n_go` , `start_time` , `register_time` , `respawn` , `respawn_interval` )
VALUES ( 'sitngo9', 'Sit and Go 9 players, Holdem', 'Sit and Go 9 players', '9', 'holdem', 'level-15-30-no-limit', '9', 1, '300000', '0', 'y', '0', '0', 'y', '0' );

INSERT INTO `tourneys_schedule` ( `name`, `description_short` , `description_long` , `players_quota` , `variant` , `betting_structure` , `seats_per_game` , `currency_serial` , `buy_in` , `rake` , `sit_n_go` , `start_time` , `register_time` , `respawn` , `respawn_interval` )
VALUES ( 'sitngo10', 'Sit and Go single table, Holdem', 'Sit and Go single table', '10', 'holdem', 'level-15-30-no-limit', '10', 1, '300000', '0', 'y', '0', '0', 'y', '0' );

INSERT INTO `tourneys_schedule` ( `name`, `description_short` , `description_long` , `players_quota` , `variant` , `betting_structure` , `seats_per_game` , `currency_serial` , `buy_in` , `rake` , `sit_n_go` , `start_time` , `register_time` , `respawn` , `respawn_interval` )
VALUES ( 'sitngo20', 'Sit and Go 2 tables, Holdem', 'Sit and Go 2 tables', '20', 'holdem', 'level-15-30-no-limit', '10', 1, '300000', '0', 'y', '0', '0', 'y', '0' );

INSERT INTO `tourneys_schedule` ( `name`, `description_short` , `description_long` , `players_quota` , `variant` , `betting_structure` , `seats_per_game` , `currency_serial` , `buy_in` , `rake` , `sit_n_go` , `start_time` , `register_time` , `respawn` , `respawn_interval` )
VALUES ( 'sitngo30', 'Sit and Go 3 tables, Holdem', 'Sit and Go 3 tables', '30', 'holdem', 'level-15-30-no-limit', '10', 1, '300000', '0', 'y', '0', '0', 'y', '0' );

INSERT INTO `tourneys_schedule` ( `name`, `description_short` , `description_long` , `players_quota` , `variant` , `betting_structure` , `seats_per_game` , `currency_serial` , `buy_in` , `rake` , `sit_n_go` , `start_time` , `register_time` , `respawn` , `respawn_interval` )
VALUES ( 'sitngo50', 'Sit and Go 5 tables, Holdem', 'Sit and Go 5 tables', '50', 'holdem', 'level-15-30-no-limit', '10', 1, '300000', '0', 'y', '0', '0', 'y', '0' );
--
-- Omaha sit and go
--
INSERT INTO `tourneys_schedule` ( `name`, `description_short` , `description_long` , `players_quota` , `variant` , `betting_structure` , `seats_per_game` , `currency_serial` , `buy_in` , `rake` , `sit_n_go` , `start_time` , `register_time` , `respawn` , `respawn_interval` )
VALUES ( 'Ositngo2', 'Sit and Go 2 players, Omaha', 'Sit and Go 2 players', '2', 'omaha', 'level-15-30-no-limit', '2', 1, '300000', '0', 'y', '0', '0', 'y', '0' );

INSERT INTO `tourneys_schedule` ( `name`, `description_short` , `description_long` , `players_quota` , `variant` , `betting_structure` , `seats_per_game` , `currency_serial` , `buy_in` , `rake` , `sit_n_go` , `start_time` , `register_time` , `respawn` , `respawn_interval` )
VALUES ( 'Ositngo3', 'Sit and Go 3 players, Omaha', 'Sit and Go 3 players', '3', 'omaha', 'level-15-30-no-limit', '3', 1, '300000', '0', 'y', '0', '0', 'y', '0' );

INSERT INTO `tourneys_schedule` ( `name`, `description_short` , `description_long` , `players_quota` , `variant` , `betting_structure` , `seats_per_game` , `currency_serial` , `buy_in` , `rake` , `sit_n_go` , `start_time` , `register_time` , `respawn` , `respawn_interval` )
VALUES ( 'Ositngo4', 'Sit and Go 4 players, Omaha', 'Sit and Go 4 players', '4', 'omaha', 'level-15-30-no-limit', '4', 1, '300000', '0', 'y', '0', '0', 'y', '0' );

INSERT INTO `tourneys_schedule` ( `name`, `description_short` , `description_long` , `players_quota` , `variant` , `betting_structure` , `seats_per_game` , `currency_serial` , `buy_in` , `rake` , `sit_n_go` , `start_time` , `register_time` , `respawn` , `respawn_interval` )
VALUES ( 'Ositngo5', 'Sit and Go 5 players, Omaha', 'Sit and Go 5 players', '5', 'omaha', 'level-15-30-no-limit', '5', 1, '300000', '0', 'y', '0', '0', 'y', '0' );

INSERT INTO `tourneys_schedule` ( `name`, `description_short` , `description_long` , `players_quota` , `variant` , `betting_structure` , `seats_per_game` , `currency_serial` , `buy_in` , `rake` , `sit_n_go` , `start_time` , `register_time` , `respawn` , `respawn_interval` )
VALUES ( 'Ositngo6', 'Sit and Go 6 players, Omaha', 'Sit and Go 6 players', '6', 'omaha', 'level-15-30-no-limit', '6', 1, '300000', '0', 'y', '0', '0', 'y', '0' );

INSERT INTO `tourneys_schedule` ( `name`, `description_short` , `description_long` , `players_quota` , `variant` , `betting_structure` , `seats_per_game` , `currency_serial` , `buy_in` , `rake` , `sit_n_go` , `start_time` , `register_time` , `respawn` , `respawn_interval` )
VALUES ( 'Ositngo7', 'Sit and Go 7 players, Omaha', 'Sit and Go 7 players', '7', 'omaha', 'level-15-30-no-limit', '7', 1, '300000', '0', 'y', '0', '0', 'y', '0' );

INSERT INTO `tourneys_schedule` ( `name`, `description_short` , `description_long` , `players_quota` , `variant` , `betting_structure` , `seats_per_game` , `currency_serial` , `buy_in` , `rake` , `sit_n_go` , `start_time` , `register_time` , `respawn` , `respawn_interval` )
VALUES ( 'Ositngo8', 'Sit and Go 8 players, Omaha', 'Sit and Go 8 players', '8', 'omaha', 'level-15-30-no-limit', '8', 1, '300000', '0', 'y', '0', '0', 'y', '0' );

INSERT INTO `tourneys_schedule` ( `name`, `description_short` , `description_long` , `players_quota` , `variant` , `betting_structure` , `seats_per_game` , `currency_serial` , `buy_in` , `rake` , `sit_n_go` , `start_time` , `register_time` , `respawn` , `respawn_interval` )
VALUES ( 'Ositngo9', 'Sit and Go 9 players, Omaha', 'Sit and Go 9 players', '9', 'omaha', 'level-15-30-no-limit', '9', 1, '300000', '0', 'y', '0', '0', 'y', '0' );

INSERT INTO `tourneys_schedule` ( `name`, `description_short` , `description_long` , `players_quota` , `variant` , `betting_structure` , `seats_per_game` , `currency_serial` , `buy_in` , `rake` , `sit_n_go` , `start_time` , `register_time` , `respawn` , `respawn_interval` )
VALUES ( 'Ositngo10', 'Sit and Go single table, Omaha', 'Sit and Go single table', '10', 'omaha', 'level-15-30-no-limit', '10', 1, '300000', '0', 'y', '0', '0', 'y', '0' );

INSERT INTO `tourneys_schedule` ( `name`, `description_short` , `description_long` , `players_quota` , `variant` , `betting_structure` , `seats_per_game` , `currency_serial` , `buy_in` , `rake` , `sit_n_go` , `start_time` , `register_time` , `respawn` , `respawn_interval` )
VALUES ( 'Ositngo20', 'Sit and Go 2 tables, Omaha', 'Sit and Go 2 tables', '20', 'omaha', 'level-15-30-no-limit', '10', 1, '300000', '0', 'y', '0', '0', 'y', '0' );

INSERT INTO `tourneys_schedule` ( `name`, `description_short` , `description_long` , `players_quota` , `variant` , `betting_structure` , `seats_per_game` , `currency_serial` , `buy_in` , `rake` , `sit_n_go` , `start_time` , `register_time` , `respawn` , `respawn_interval` )
VALUES ( 'Ositngo30', 'Sit and Go 3 tables, Omaha', 'Sit and Go 3 tables', '30', 'omaha', 'level-15-30-no-limit', '10', 1, '300000', '0', 'y', '0', '0', 'y', '0' );

INSERT INTO `tourneys_schedule` ( `name`, `description_short` , `description_long` , `players_quota` , `variant` , `betting_structure` , `seats_per_game` , `currency_serial` , `buy_in` , `rake` , `sit_n_go` , `start_time` , `register_time` , `respawn` , `respawn_interval` )
VALUES ( 'Ositngo50', 'Sit and Go 5 tables, Omaha', 'Sit and Go 5 tables', '50', 'omaha', 'level-15-30-no-limit', '10', 1, '300000', '0', 'y', '0', '0', 'y', '0' );

INSERT INTO `tourneys_schedule` (`serial`, `name`, `description_short`, `description_long`, `players_quota`, `variant`, `betting_structure`, `seats_per_game`, `currency_serial`, `buy_in`, `rake`, `sit_n_go`, `breaks_interval`, `rebuy_delay`, `add_on`, `add_on_delay`, `start_time`, `register_time`, `respawn`, `respawn_interval`) VALUES ('', 'regular1', 'Holdem No Limit, 200 + 10', 'Holdem No Limit, 200 + 10', '1000', 'holdem', 'level-15-30-no-limit', '10', 1, '20000', '1000', 'n', '60', '30', '1', '60', unix_timestamp(now() + interval 8 hour), unix_timestamp(now() + interval 7 hour), 'n', '0');
INSERT INTO `tourneys_schedule` (`serial`, `name`, `description_short`, `description_long`, `players_quota`, `variant`, `betting_structure`, `seats_per_game`, `currency_serial`, `buy_in`, `rake`, `sit_n_go`, `breaks_interval`, `rebuy_delay`, `add_on`, `add_on_delay`, `start_time`, `register_time`, `respawn`, `respawn_interval`) VALUES ('', 'regular2', 'Holdem No Limit, 2000 + 100', 'Holdem No Limit, 2000 + 100', '1000', 'holdem', 'level-15-30-no-limit', '10', 1, '200000', '10000', 'n', '60', '30', '1', '60', unix_timestamp(now() + interval 9 hour), unix_timestamp(now() + interval 8 hour), 'n', '0');
INSERT INTO `tourneys_schedule` (`serial`, `name`, `description_short`, `description_long`, `players_quota`, `variant`, `betting_structure`, `seats_per_game`, `currency_serial`, `buy_in`, `rake`, `sit_n_go`, `breaks_interval`, `rebuy_delay`, `add_on`, `add_on_delay`, `start_time`, `register_time`, `respawn`, `respawn_interval`) VALUES ('', 'regular1', 'Omaha No Limit, 200 + 10', 'Omaha No Limit, 200 + 10', '1000', 'omaha', 'level-15-30-no-limit', '10', 1, '20000', '1000', 'n', '60', '30', '1', '60', unix_timestamp(now() + interval 10 hour), unix_timestamp(now() + interval 9 hour), 'n', '0');
INSERT INTO `tourneys_schedule` (`serial`, `name`, `description_short`, `description_long`, `players_quota`, `variant`, `betting_structure`, `seats_per_game`, `currency_serial`, `buy_in`, `rake`, `sit_n_go`, `breaks_interval`, `rebuy_delay`, `add_on`, `add_on_delay`, `start_time`, `register_time`, `respawn`, `respawn_interval`) VALUES ('', 'regular2', 'Omaha No Limit, 2000 + 100', 'Omaha No Limit, 2000 + 100', '1000', 'omaha', 'level-15-30-no-limit', '10', 1, '200000', '10000', 'n', '60', '30', '1', '60', unix_timestamp(now() + interval 11 hour), unix_timestamp(now() + interval 10 hour), 'n', '0');
INSERT INTO `tourneys_schedule` (`serial`, `name`, `description_short`, `description_long`, `players_quota`, `variant`, `betting_structure`, `seats_per_game`, `currency_serial`, `buy_in`, `rake`, `sit_n_go`, `breaks_interval`, `rebuy_delay`, `add_on`, `add_on_delay`, `start_time`, `register_time`, `respawn`, `respawn_interval`) VALUES ('', 'regular1', 'Omaha8 No Limit, 200 + 10', 'Omaha8 No Limit, 200 + 10', '1000', 'omaha8', 'level-15-30-no-limit', '10', 1, '20000', '1000', 'n', '60', '30', '1', '60', unix_timestamp(now() + interval 12 hour), unix_timestamp(now() + interval 11 hour), 'n', '0');
INSERT INTO `tourneys_schedule` (`serial`, `name`, `description_short`, `description_long`, `players_quota`, `variant`, `betting_structure`, `seats_per_game`, `currency_serial`, `buy_in`, `rake`, `sit_n_go`, `breaks_interval`, `rebuy_delay`, `add_on`, `add_on_delay`, `start_time`, `register_time`, `respawn`, `respawn_interval`) VALUES ('', 'regular2', 'Omaha8 No Limit, 2000 + 100', 'Omaha8 No Limit, 2000 + 100', '1000', 'omaha8', 'level-15-30-no-limit', '10', 1, '200000', '10000', 'n', '60', '30', '1', '60', unix_timestamp(now() + interval 13 hour), unix_timestamp(now() + interval 12 hour), 'n', '0');

DROP TABLE IF EXISTS tourneys;

CREATE TABLE tourneys (
  serial INT UNSIGNED NOT NULL AUTO_INCREMENT,
  name VARCHAR(32),
  description_short VARCHAR(64),
  description_long TEXT,
  players_quota INT DEFAULT 10,
  variant VARCHAR(32),
  betting_structure VARCHAR(32),
  seats_per_game INT DEFAULT 10,
  currency_serial INT,
  buy_in INT,
  rake INT,
  sit_n_go CHAR DEFAULT 'y',
  breaks_interval INT DEFAULT 60,
  rebuy_delay INT DEFAULT 0,
  add_on INT DEFAULT 0,
  add_on_delay INT DEFAULT 60,
  start_time INT DEFAULT 0,

  finish_time INT DEFAULT 0,
  state VARCHAR(32) DEFAULT "registering",
  schedule_serial INT,
  add_on_count INT DEFAULT 0,
  rebuy_count INT DEFAULT 0,

  PRIMARY KEY (serial)
)  ENGINE=InnoDB CHARSET=utf8;

DROP TABLE IF EXISTS user2tourney;

CREATE TABLE user2tourney (
  user_serial INT NOT NULL,
  tourney_serial INT NOT NULL,
  table_serial INT,
  rank INT DEFAULT -1,

  PRIMARY KEY (user_serial, tourney_serial)
)  ENGINE=InnoDB CHARSET=utf8;

--
-- Default users
--
INSERT INTO users (serial, name, privilege) VALUES (1, ' rake ', 0);

INSERT INTO users (serial, name, password, privilege) VALUES (2, 'admin', 'REPLACE', 2);
INSERT INTO users_private (serial) VALUES (2);

INSERT INTO users (serial, name, password, privilege) VALUES (3, 'admin_web', 'REPLACE', 1);
INSERT INTO users_private (serial) VALUES (3);

DROP TABLE IF EXISTS users_transactions;
--
-- Transactions between users
--
CREATE TABLE users_transactions (
  from_serial INT UNSIGNED NOT null,
  to_serial INT UNSIGNED NOT null,
  modified TIMESTAMP,
  amount INT DEFAULT 0,
  currency_serial INT NOT NULL,
  status CHAR DEFAULT 'n',
  notes TEXT,

  KEY (from_serial,to_serial)
);

DROP TABLE IF EXISTS affiliates;
--
-- Affiliate description
--
create table affiliates (
  serial INT UNSIGNED NOT NULL AUTO_INCREMENT,
  modified TIMESTAMP,
  created INT UNSIGNED NOT NULL,

  users_count INT UNSIGNED DEFAULT 0,
  users_rake INT UNSIGNED DEFAULT 0,
  users_points INT UNSIGNED DEFAULT 0,

  --
  -- percentage of the rake assigned to the affiliate
  --
  share INT UNSIGNED DEFAULT 0, 

  companyname VARCHAR(255) DEFAULT "",
  firstname VARCHAR(255) DEFAULT "",
  lastname VARCHAR(255) DEFAULT "",
  addr_street VARCHAR(255) DEFAULT "",
  addr_street2 VARCHAR(255) DEFAULT "",
  addr_zip VARCHAR(64) DEFAULT "",
  addr_town VARCHAR(64) DEFAULT "",
  addr_state VARCHAR(128) DEFAULT "",
  addr_country VARCHAR(64) DEFAULT "",
  phone VARCHAR(64) DEFAULT "",

  url TEXT,
  notes TEXT,

  PRIMARY KEY (serial)
);

DROP TABLE IF EXISTS messages;

CREATE TABLE messages (
  serial INT UNSIGNED NOT NULL AUTO_INCREMENT,
  send_date TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  message TEXT DEFAULT '',
  sent CHAR DEFAULT 'n',

  PRIMARY KEY (serial, send_date, sent)
)  ENGINE=InnoDB CHARSET=utf8;
