# AC_CHECK_NGL
#
# Check and configure for the NGL library

dnl AC_CHECK_NGL([MINIMUM-VERSION, [ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]]])
dnl Test for NGL, and define NGL_CFLAGS and NGL_LIBS
dnl
AC_DEFUN(AC_CHECK_NGL,
[dnl
dnl Get the cflags and libraries from the ngl-config script
dnl
AC_ARG_WITH(ngl_path,
            [  --with-ngl-path=PATH   path to NGL distribution (optional)],
            ngl_path="$withval",
            ngl_path="")

NGL_CFLAGS=""
NGL_LIBS=""

if test "x$ngl_path" != x ; then
  # Compile using an uninstalled distribution
  NGL_CFLAGS="-I$ngl_path/include $NGL_CFLAGS"
  NGL_LIBS="-L$ngl_path/src $NGL_LIBS"
  ngl_config_path="$ngl_path"
else
  ngl_config_path="$PATH"
fi
AC_PATH_PROG(NGL_CONFIG, ngl-config, no, [$ngl_config_path])

AC_MSG_CHECKING(for NGL library)
if test "$NGL_CONFIG" = "no" ; then
   AC_MSG_RESULT(no)
   ifelse([$3], , :, [$3])
else
  AC_MSG_RESULT(yes)
  NGL_CFLAGS="`$NGL_CONFIG --cflags` $NGL_CFLAGS"
  NGL_LIBS="`$NGL_CONFIG --libs` $NGL_LIBS"
  ifelse([$2], , :, [$2])
fi

AC_SUBST(NGL_CFLAGS)
AC_SUBST(NGL_LIBS)
])


# AC_CHECK_NUI
#
# Check and configure for the NUI library

dnl AC_CHECK_NUI([MINIMUM-VERSION, [ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]]])
dnl Test for NUI, and define NUI_CFLAGS and NUI_LIBS
dnl
AC_DEFUN(AC_CHECK_NUI,
[dnl
dnl Get the cflags and libraries from the nui-config script
dnl
AC_ARG_WITH(nui_path,
            [  --with-nui-path=PATH   path to NUI distribution (optional)],
            nui_path="$withval",
            nui_path="")

NUI_CFLAGS=""
NUI_LIBS=""

if test "x$nui_path" != x ; then
  # Compile using an uninstalled distribution
  NUI_CFLAGS="-I$nui_path/include $NUI_CFLAGS"
  NUI_LIBS="-L$nui_path/src $NUI_LIBS"
  nui_config_path="$nui_path"
else
  nui_config_path="$PATH"
fi
AC_PATH_PROG(NUI_CONFIG, nui-config, no, [$nui_config_path])

AC_MSG_CHECKING(for NUI library)
if test "$NUI_CONFIG" = "no" ; then
   AC_MSG_RESULT(no)
   ifelse([$3], , :, [$3])
else
  AC_MSG_RESULT(yes)
  NUI_CFLAGS="`$NUI_CONFIG --cflags` $NUI_CFLAGS"
  NUI_LIBS="`$NUI_CONFIG --libs` $NUI_LIBS"
  ifelse([$2], , :, [$2])
fi

AC_SUBST(NUI_CFLAGS)
AC_SUBST(NUI_LIBS)
])
