/*
 *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Loic Dachary <loic@gnu.org>
 *  Henry Prcheur <henry@precheur.org>
 *  Igor Kravtchenko <igor@obraz.net>
 *
 */

#ifndef	_poker_application_h
#define	_poker_application_h

#include <maf/application.h>
#include <maf/application2d.h>
#include <maf/camera.h>
#include <maf/scene.h>
#include <maf/audio.h>

#include <ugame/text.h>

#ifdef WIN32
#include "pokerexport.h"
#endif // WIN32

#include <Poker.h>
#include <PokerCamera.h>

class MAFSceneController;
class MAFRepositoryData;
class MAFOSGData;
class PokerDeck;
class PokerController;
class PokerCursor;

class POKER_EXPORT PokerApplication : public MAFApplication
{
public:
  PokerApplication();
  virtual ~PokerApplication();

  void Load();
  virtual void PythonAccept(PyObject* pypacket);
  virtual void SendPacket(const std::string &packetName);

  virtual void Init(void);
  virtual void SplashScreen(void);
  virtual void OnExit(int Code);

  void SetPyScheduler(PyObject* scheduler) { mPyScheduler = scheduler; }
  PyObject* GetPyScheduler(void) { return mPyScheduler; }

  void MoveTo(const MAFCameraModel& target, 
	      const PokerCameraModel::PointFunctor& positionPointGenerator);
  void MoveTo(const MAFCameraModel& target, 
	      const PokerCameraModel::PointFunctor& positionPointGenerator,
	      const PokerCameraModel::PointFunctor& targetPointGenerator);
  virtual osg::Referenced* SearchAnimated(const std::string& name);
	      
  PokerController* GetPoker() { return mPoker.get(); }
  MAFApplication2DController* GetInterface() { return mApplication2D.get(); }

  MAFOSGData* mSetData;
  osg::Group *mShadowedGroup;

  MAFRepositoryData* mDatas;
  PokerDeck* mDeck;
  float mCameraTimeToReach;
  MAFCameraModel mDefaultCamera;
  MAFCameraModel mPreviousCamera;

  PokerCursor* mCursor;
  bool mShadowFlag;
  
private:
  PyObject* mPyScheduler;
  osg::ref_ptr<MAFVisionController> mSplashScreen;
  osg::ref_ptr<PokerController> mPoker;
  osg::ref_ptr<MAFApplication2DController> mApplication2D;
  osg::ref_ptr<MAFAudioController> mSoundtrack;
};

#endif /* _poker_application_h */
