/*
 *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Loic Dachary <loic@gnu.org>
 *
 */
#ifndef poker_error_h
#define poker_error_h

#include <maf/maferror.h>

#define UNDERWARE_POKER_ERROR underware_poker_error_quark()

GQuark underware_poker_error_quark(void);

typedef enum {
  UNDERWARE_POKER_ERROR_CARD,
  UNDERWARE_POKER_ERROR_ANIMATION,
  UNDERWARE_POKER_ERROR_FAILED, // Generic
} UnderwarePokerError;

class PokerError  : public MAFError {
public:
  PokerError(GError* error);
  PokerError(gint code, const gchar* format, ...);
  PokerError(GQuark domain, gint code, const gchar* format, ...);
  virtual ~PokerError();
};

#endif // poker_error_h
