/* -*- c++ -*-
 *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Loic Dachary <loic@gnu.org>
 *  Johan Euphrosine <johan@mekensleep.org>
 *
 */

#ifndef _pokerinteractor_h
#define _pokerinteractor_h

#include <vector>

#include <ugame/artefact.h>

class PokerApplication;
class MAFPacket;

struct PokerInteractor : public UGAMEArtefactController
{
  PokerInteractor();
  virtual ~PokerInteractor() {}
  bool Update(MAFApplication *application);
  bool mClickStatus;
  bool mStealedCamera;
  bool mWasClickedFocused;
  float mDelta;
  bool mDirtyDisplay;
  void Init(PokerApplication* game, MAFOSGData* seatData, const std::string &urlPrefix);
  void Finit(PokerApplication *game);
  void InitNode(PokerApplication* game, const std::string &nodeUrl);
  void Accept(MAFPacket *packet);
  void UpdateDisplay(bool clickAndFocused);
  void SetNodeDisplayed(const std::string &state, bool displayed);
  bool GetNodeDisplayed(const std::string &state);
  void GrabCamera(MAFApplication *application, bool status);
  std::map<std::string, osg::ref_ptr<osg::Node> > mNodes;  
  std::map<std::string ,std::string > mState2Name;
  std::vector<std::string> mNodes2Clear;
};

#endif // _pokerinteractor_h
