/*
 *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Loic Dachary <loic@gnu.org>
 *  Cedric Pinson <cpinson@freesheep.org>
 *
 */

#ifndef _pokerplayer_h
#define _pokerplayer_h

#include <map>
#include <vector>
#include <string>

#include <osg/Vec2>
#include <osgText/Text>

#include <maf/audio.h>
#include <ugame/artefact.h>

#include <PokerCard.h>
#include <PokerInteractor.h>
#include <PokerShowdown.h>
#include <osgText/Text>
#include <maf/audio.h>
#include <osg/Array>
// #include <PokerChipsStack.h>
#include <PokerMoveChips.h>
#include <osg/ShapeDrawable>

#include <osg/ShapeDrawable>

class osg::Geometry;
class osg::Geode;

class PokerPlayerCamera;
class PokerApplication;
class UGAMEAnimatedController;
class PlayerAnimation;
class PokerChipsStackController;
class PokerBubbleController;
class PokerBodyController;
class PokerMoveChipsController;
class PokerMoveChipsBet2PotController;
class SoundInit;
class PokerCursor;

#define POKER_PLAYER_NO_SEAT 255

// todo remove me
#include <maf/packets.h>
struct PokerDummyCaller : UGAMEArtefactController
{
  PokerDummyCaller() {}
  void Init(MAFOSGData *seatData);
  bool Update(MAFApplication *application);
  void SendPacket(MAFApplication *application);
};


struct PokerDummySlider : UGAMEArtefactController
{
  PokerDummySlider() {}
  void Init(MAFOSGData *seatData);
  bool Update(MAFApplication *application);
  void SendPacket(MAFApplication *application);
};

class PokerPlayer : public MAFController {

  void GetTypeAndNameFromOutfit(const std::string& outfit,std::string& name,std::string& type);

public:
  PokerPlayer(PokerApplication* game, bool me, const std::string& outfitName);
  virtual ~PokerPlayer();

  bool Update(MAFApplication* application);

  UGAMEArtefactController* GetSeat(void) { return mSeat.get(); }

  void BodyCollideAll(void);
  void BodyCollideCards(void);
  void VisibleCards(bool visible);
  void NoCards(void);
  void FoldHoleCards(void);
  void SetHoleCards(const std::vector<int>& cards);
  PokerShowdownController* GetShowdown(void) { return mShowdown.get(); }
  void SetPocketCards(const std::vector<int>& cards);
  void FoldPocketCards(void);


  void SetMoney(const std::vector<int>& amount);
  void SetBet(const std::vector<int>& amount);  
  void BetLimits(int min_bet, int max_bet, int step, int call);

  unsigned GetSelectedValue();
  void	ResetSelectedValue();

  const std::string& GetLastActionString() const { return m_strLastAction; }
  void SetLastActionString(const std::string &str) { m_strLastAction = str; }
  int GetLastBet() const { return m_lastBet; }
  void SetLastBet(int bet) { m_lastBet = bet; }

  void SetInGame(bool inGame);
  bool GetInGame(void) { return mInGame; }

  void SetName(const std::string& name);
  const std::string& GetName(void) const { return mName; }

  PokerBodyController* GetBody(void) { return mBody.get(); }

  void SetSeatId(int seat);
  int GetSeatId(void) const { return mSeatId; }

  void SetSit(bool sit);
  bool GetSit(void) { return mSit; }

  void InPosition();
  void LostPosition();
  bool HasPosition() const { return mInPosition; }

  void LookAt(PokerPlayer* player);

//   void Folding();
//   void EndFolding();

  void DisableWarningTimer();


  void Win();
  void Loose();
  void Bet();
  void Check();

  void SetTextMessage(const std::string &message);

  double PlayStartLookCards();
  double PlayEndLookCards();

  const osg::Vec3& GetPositionOfPlayer() const { return mPositionOfPlayerInWorldspace;}
  const osg::Vec3& GetDirectionOfPlayer() const { return mDirectionOfPlayerInWorldspace;}

  // advise player that he has to play else he will fold
  void TimeoutAdvise(float timeToPlay);



 public:

  void GetCount();

  PokerApplication* mGame;
  osg::ref_ptr<PokerChipsStackController>	mMoneyStack;
  osg::ref_ptr<PokerChipsStackController>	mBetStack;
  osg::MatrixTransform *mShadowMT;
  
  PokerCardControllerVector mHole;

  std::map<std::string,osg::ref_ptr<UGAMEArtefactController> > mInteractors;

  bool GetMe(void) { return mMe; }
  void SetMe(bool s) { mMe=s;}

  MAFAudioController* GetSound(const SoundInit& sound);//const std::string& name,const std::string& anchor,float referenceDistance);

  std::vector<osg::ref_ptr<PokerMoveChipsBet2PotController> > mMoveChipsFromBetToPot;
/*   osg::ref_ptr<PokerMoveChipsController> mMoveChipsFromPlayerToBet; */
  std::vector<osg::ref_ptr<PokerMoveChipsPot2PlayerController> > mMoveChipsFromPotToPlayer;

  PokerMoveChipsBet2PotController* GetFreeAnimationBet2Pot();
  PokerMoveChipsPot2PlayerController* GetFreeAnimationPot2Player();

  PokerChipsStackController* GetMoneyStack() { return mMoneyStack.get() ;}
  PokerChipsStackController* GetBetStack() { return mBetStack.get() ;}

  int GetNbCardsDisplayed();

private:

  osg::ref_ptr<UGAMEArtefactController> mSeat;
  MAFOSGData* mSeatData;

  void MarkLastAction();

  std::string mName;
  int mSeatId;
  //bool mAnimationsAuto;
  //PlayerAnimation* mAnimations;
  bool mInPosition;
  bool mInGame;
  bool mSit;

  bool mDisplayBubble;
  osg::ref_ptr<PokerBubbleController> mBubble;
  PokerPlayerCamera* mCamera;
  osg::ref_ptr<PokerShowdownController> mShowdown;

  double mTimePlaying;
  double mTimeWaiting;
  double mTimeNoise;
  double mInternalTime; // time since the player is here

  osg::Vec3 mPositionOfPlayerInWorldspace; 
  osg::Vec3 mDirectionOfPlayerInWorldspace;

  bool mMe; // true if it's me
  struct MouseState
  {
    MouseState() :  mRightButtonClicked(false), mLeftButtonClicked(false), mStateChanged(false), mWarp(false), mX(0), mY(0), mRX(0), mRY(0) {}
    void LeftClick(bool state) {mLeftButtonClicked = state; mStateChanged = true;}
    void Update(SDL_Event *event);
    void WarpMouse(bool state);
    void Init(PokerCursor* cursor) { mCursor=cursor;}

    PokerCursor* mCursor;
    bool mRightButtonClicked;
    bool mLeftButtonClicked;
    bool mStateChanged;
    bool mWarp;
    int  mX;
    int  mY;
    int  mRX;
    int  mRY;
  };
  MouseState mMouseState;
  int mStandUpAnimationId;
  double mMoveTimeout;
  double mSitInTimeout;
  bool mClickOnChair;
  void UpdateSitIn();
  void UpdateSittingOut();
  void UpdateSitOut();

  void SendPacketSitOut();
  void SendPacketSit();

  osg::ref_ptr<PokerBodyController> mBody;

  osg::ref_ptr<osg::Geode> mCounterGeode;
  osg::ref_ptr<osgText::Text> mCounterText;
  float mCounterCurrent;
  float mCounterFadeOut;
  std::string mCollideCards;
  std::vector<std::string> mCollideAll;
  bool mCounterDisplay;

//   osg::ref_ptr<MAFAudioController> mSoundStartLookCard;
//   osg::ref_ptr<MAFAudioController> mSoundBet;


  // should be removed when sounds test will be removed
//   std::vector<osg::ref_ptr<MAFAudioController> > mTestSounds;

  
  std::map<std::string,osg::ref_ptr<MAFAudioController> >mSounds;
  

  osg::Vec3 mBeginPos;
  osg::Vec3 mCurrentPos;
  osg::Vec3 mDeltaPos;
  bool mDeltaSet;
  float mDiffPosLengthLimit;
  float mDeltaIncrement;

  bool mShadowFlag;

 public:
  osg::ref_ptr<PokerDummySlider> mSlider;
  osg::ref_ptr<PokerDummyCaller> mCaller;
  osg::ref_ptr<PokerInteractor> mFoldInteractor;
  osg::ref_ptr<PokerInteractor> mCheckInteractor;

  std::string m_strLastAction;
  int m_lastBet;

  osg::ref_ptr<osg::Group> mAnimate1CardAnchor;
  std::vector<osg::ref_ptr<osg::MatrixTransform> > mAnimate1Card;
  int mCurrent1Card;

  void ShowCard(int i);
  void HideCard(int i);

  int GetMaxCardsAnimation();
  void AnimateCard(int i);
  osg::MatrixTransform* GetAnimationCard(int i);
  void HideAnimateCard(int i);


};

#endif // _pokerplayer_h
