/*
 *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 * Cedric Pinson cpinson@freesheep.org
 *
 */

#ifndef _poker_pot_h
#define _poker_pot_h

#include <maf/model.h>
#include <maf/view.h>
#include <maf/controller.h>
#include <osg/Matrix>
#include <osg/MatrixTransform>
#include <maf/interpolator.h>
#include <maf/data.h>
#include <PokerMoveChips.h>

class PokerApplication;
class PokerChipsStack;

class PokerPotController : public MAFController
{
  
  PokerApplication* mGame;

public:
  PokerPotController(PokerApplication* game);
  ~PokerPotController();
  
  bool Update(MAFApplication* game);

  float BuildAnimationBetToPot(PokerMoveChipsBet2PotController* animation,int pot);
  float BuildAnimationPotToPlayer(PokerMoveChipsPot2PlayerController* animation,int pot);

  // stop center to animate bet to pot or to animate pot to player
  void FreezeCenter();
  void UnFreezeCenter();
  

  // align the side pot 'pot' to the view
  void SetCurrentPot(int pot);


  // accessors to control chips side pot
  void SetPotValue(const std::vector<int>& value,int index);
  PokerChipsStackController* GetPotChipsStack(int index) {
    return mChips[index].get();
  }

  osg::MatrixTransform* GetPot(int index) { return mPots[index].get();}

  bool IsFreezed() { return mFreezeCenter;}
  bool IsStopped() { return !mCenterIsMoving;}
  bool IsStopping() {
    if (mFreezeCenter && mCenterIsMoving)
      return true;
    return false;
  }

  void ResetPots();

private:

  bool mCanModifyTarget;
  float mCrackDuration,mCrackSign,mTimeCrack,mCrackAmplitude,mParamStartCrack,mCrackAngle;
  int mCrackAnim,mStartCrack;

  float mParamRadiusCenter;
  bool mFreezeCenter;
  float mParamMaxAngleToFreezeCenter;
  osg::Matrix mInitialMatrix;
  osg::ref_ptr<osg::MatrixTransform> mCenterTransform;
  float mCurrentAngle;
  int mCurrentPotIndex;
  osg::Vec3 mInitialDirection;
  osg::Vec3 mCurrentPotDirection;
  bool mCenterIsMoving;
  float mTargetAngle;
  float mTimeBeforeMoving;
  float mTimeLastMove;

  float mParamStopThreshold;
  float mParamTimeBeforeMoving;
  float mParamMinIncToMove;

  float mAngularSpeed;

  int mTargetSidePot,mCurrentSidePot; 
  float mSidePotTimer;

  std::vector<osg::ref_ptr<osg::MatrixTransform> > mPots;
  std::vector<osg::ref_ptr<PokerChipsStackController> > mChips;

  MAFBezierInterpolator<float> mInterpolator;

  bool IsTargetReach(float threshold);

  void LoadKeys(std::vector<osg::Vec2> &keys, MAFXmlData *data, const std::string &name);

  template<typename T>
    void LoadSpline(T &interpolator, MAFXmlData *data, const std::string &name)
    {
      std::vector<osg::Vec2> keys;
      LoadKeys(keys, data, name);
      interpolator.InitKeys(keys);
    }

  void UpdateSidePotDirection(float dt);
  osg::Vec3 GetSidePotDirection(int i);

};

#endif
