/*
 *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Johan Euphrosine <johan@mekensleep.com>
 *  Cedric Pinson <cpinson@freesheep.org>
 *
 */

#include "pokerStdAfx.h"

#ifndef WIN32
#	include <PokerSound.h>
#	include <maf/data.h>
#	include <maf/maferror.h>
#endif

#include <list>

bool LoadSoundSettings(std::vector<SoundInit>& settings, MAFXmlData *data)
{
  if (!data)
    return false;

  const std::list<std::string> &names = data->GetList("/sounds/item/@name");
  const std::list<std::string> &snames = data->GetList("/sounds/item/@soundname");
  const std::list<std::string> &anchors = data->GetList("/sounds/item/@anchor");
  const std::list<std::string> &refDistance = data->GetList("/sounds/item/@referenceDistance");
  const std::list<std::string> &rolloff = data->GetList("/sounds/item/@rolloff");

  settings.clear();
  if (names.size() != anchors.size())
    g_assert(0 && "LoadSoundSettings a name or an anchor is missed in /sounds/item");

  typedef std::list<std::string>::const_iterator It;
  It nameBegin = names.begin();
  It nameEnd = names.end();

  It snameBegin = snames.begin();
  It anchorBegin = anchors.begin();
  It refDistBegin = refDistance.begin();
  It rolloffBegin = rolloff.begin();
  
  while (nameBegin != nameEnd) {
    float a=atof(refDistBegin->c_str());
    float b=atof(rolloffBegin->c_str());
    settings.push_back(SoundInit(*nameBegin,*snameBegin,*anchorBegin,a,b));
    nameBegin++;
    snameBegin++;
    anchorBegin++;
    refDistBegin++;
    rolloffBegin++;
  }
  return true;
}
