/*
 *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 * Henry Precheur	<henry@precheur.org>
 *
 */

#ifndef	_pokertooltip_h
#define	_pokertooltip_h

#include <map>
#include <maf/vision.h>

struct UGAMEFramedText;
class PokerApplication;
class MAFApplication;
class MAFHit;

struct PokerToolTipController: public MAFVisionController
{
  PokerToolTipController(PokerApplication* app);
  virtual ~PokerToolTipController();

  bool	Update(MAFApplication* app);

  void	HandleHit(MAFHit& hit);
  void	HandleNotHit();

  osg::Node*	GetNode();

protected:

  void	Fade(float f);
  void	Reset();

  osg::ref_ptr<osg::PositionAttitudeTransform>	mPat;
  UGAMEFramedText*	mText;
  osg::Vec4Array*	mColor;
  std::map<std::string, std::string>	mPath2Tooltip;
  unsigned	mScreenWidth, mScreenHeight;

  enum
    {
      NONE,
      PREFADEIN,
      FADEIN,
      DISPLAYED,
      FADEOUT
    }	mState;
  float	mTime;
};

#endif /* _pokertooltip_h */
