#
# Copyright (C) 2004 Mekensleep
#
# Mekensleep
# 24 rue vieille du temple
# 75004 Paris
#       licensing@mekensleep.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
# Authors:
#  Johan Euphrosine <johan@mekensleep.org>
#


class PacketSelection:
    ""
    def getType(self):
        return "selection"


class PokerInteractor:
    "Poker interactors logic"

    class state:
        def enter(self, i):
            return
        def update(self, i):
            return
        def leave(self, i):
            return
        
    class enabled(state):
        name = "enabled"
        def update(self, i):
            if i.getSelected():
                if i.inPosition:
                    i.setState(i.activated())
                else:
                    i.setState(i.scheduled())
            return
        def leave(self, i):
            return
        def getDefault(self, i):
            return "grey"
        def getClicked(self, i):
            if i.inPosition:
                return "green"
            else:
                return "yellow"

    class scheduled(state):
        name = "scheduled"
        def update(self,i):
            if i.getSelected():
                if not i.inPosition:
                    i.setState(i.enabled())
                    return
                else:
                    #???
                    return
            if i.getCanceled():
                if not i.inPosition:
                    i.setState(i.enabled())
                    return
            if i.inPosition:
                i.setState(i.activated())
                return
            return
        def getDefault(self, i):
            return "yellow"
        def getClicked(self, i):
            return "grey"

    class activated(state):
        name = "activated"
        def enter(self, i):
            i.action()
            return
        def update(self, i):
            #should it be in interactor class instead ?
            if not i.inPosition:
                i.setState(i.disabled())
            return
        def getDefault(self, i):
            return "green"
        def getClicked(self, i):
            return "green"

    class disabled(state):
        name = "disabled"
        def update(self, i):
            return
        def getDefault(self, i):
            return None
        def getClicked(self, i):
            return None       
            
    selected = 0
    canceled = 0
    state = 0
    inPosition = 0
    name = ""
    actionCallback = 0
    displayCallback = 0
    selectCallback = 0
#    def __init__(self, name):
#        self.name = name
#        self.setState(self.disabled())
#        return
    def __init__(self, name, action, display, select):
        self.name = name
        self.actionCallback = action
        self.displayCallback = display
        self.selectCallback = select
        self.setState(self.disabled())
        return
    
    def __del__(self):
        return

    def formatName(self, color):
        if color == None:
            return ""        
        return self.name + color + ".escn"

    def getDefault(self):
        return self.formatName(self.state.getDefault(self))
    def getClicked(self):
        return self.formatName(self.state.getClicked(self))
    
    def setInPosition(self, value):
        #print "setInPosition: %i" % value
        self.inPosition = value
        return
    def toggle(self):
        self.setSelected(not self.selected)
        return
    def select(self):
        self.selectCallback(self)
#        self.setSelected(1)
        return
    def setSelected(self, value):
        self.selected = value
        return
    def getSelected(self):
        value = self.selected
        self.selected = 0
        return value
    def cancel(self):
        self.setCanceled(1)
        return
    def setCanceled(self, value):
        self.canceled = value
        return
    def getCanceled(self):
        value = self.canceled
        self.canceled = 0
        return value

    def setState(self, value):
        #consume event
        self.getSelected()
        self.getCanceled()
        fromState = self.state
        toState = value
        if fromState:
            fromState.leave(self)
        if toState:
            toState.enter(self)
#        print "[setState %s -> %s]" % (fromState, toState)
        self.state = value
        return
    
    def enable(self):
        self.setState(self.enabled())
        return
    def disable(self):
        self.setState(self.disabled())
        return
    def setEnabled(self, value):
        if value:
            if self.state.name == "disabled":
                self.enable()
        else:
            self.disable()

    def isActive(self):
        return self.state.name == "activated"
        
    def update(self):
        #print self.name + " " + self.state.name
        self.state.update(self)
        return
    
    def action(self):
        self.actionCallback(self)
        return

    def display(self):
        self.displayCallback(self)
        return

def PokerInteractorUnitTest():
    "poker interactor unit test"
    interactor = PokerInteractor()        
    interactor.update()
    interactor.enable()
    interactor.update()
    interactor.click()
    interactor.update()
    interactor.update()
    interactor.setInPosition(1)
    interactor.update()
    interactor.update()
    interactor.setInPosition(0)
    interactor.update()
    interactor.update()
    interactor.toggle()
    interactor.update()
    interactor.toggle()
    interactor.update()
    interactor.update()
    
    return

#PokerInteractorUnitTest()
