"""
XMPP Component library for jabberd 1.4x
(c) 2004 Fabio Forno
"""

from twisted.internet import reactor, protocol
from xmppstream import XMPPStream, XMPPBaseFactory
import xmppstream as xmpp
from elements import *
import utils
import sha, sys

ns_accept='jabber:component:accept'

#utility functions
encoding='ISO-8859-15'

class XMPPBaseComponent(XMPPStream):
    """ Streams for Jabber components"""
    
    def __init__(self):
        """ """
        XMPPStream.__init__(self)
        #set new handlers
        self.setHandler('', 'handshake', self.gotHandshake)
        self.setHandler('', 'route', self.gotRoute)
    
    def connectionMade(self):
        """ Open the stream """
        f=self.factory
        ch=self.transport 
        s="""<?xml version='1.0' encoding='UTF-8'?>
<stream:stream to='%s' xmlns='%s' xmlns:stream='%s'>\n"""%(
            ch.getPeer()[1], f.xmlns, xmpp.ns_xmlstream)
        
        if f.debug:
            utils.debug(s, xml=1)
            
        self.writeData(s)
    
    def streamOpened(self, tag):
        """ Received the first stream event """
        XMPPStream.streamOpened(self, tag)
        # prepare and send the authorization request
        digest=sha.new(self.getId()+self.factory.secret).hexdigest()
        s=u"<handshake id='1'>%s</handshake>"%(digest)
        self.writeData(s)
    
    def gotHandshake(self, tag):
        """ """
        self.authSuccess()
        
    def authSuccess(self):
        """ override this of you want to take actions once authenticated """
        pass 

    def gotRoute(self, tag):
        """ got a route packet """
        if self.factory.debug:
            utils.debug(tag.toxml().encode(encoding, 'ingore'), xml=1)
    
    def sendMessage(self, to, subject='', body='', thread='', ttype=''):
        """ send a message (overidden since the from must be set) """
        f=self.factory
        m=Message(to=to, subject=subject, body=body, thread=thread, ttype=ttype, ffrom=f.component_name)
        self.sendPacket(m)

from roster import RosterMixIn
class XMPPComponent(XMPPBaseComponent, RosterMixIn):
    """ XMPP Component with Roster """
    
    def __init__(self):
        XMPPBaseComponent.__init__(self)
        RosterMixIn.__init__(self)
        
    def authSuccess(self):
        """ Called when the client has authenticated """
        XMPPBaseComponent.authSuccess(self)
        self.getRoster() # Is it allowed to get the roster?
        
class XMPPComponentFactory(protocol.ReconnectingClientFactory, XMPPBaseFactory):
    protocol=XMPPComponent
    xmlns=ns_accept
    
    def __init__(self, secret, component_name):
        """ """    
        XMPPBaseFactory.__init__(self)
        self.secret=secret
        self.component_name=component_name

def test_component():
    from utils import Config
    conf=Config(['component.cfg', '/etc/component.cfg'])
    #default values, change them or write a config file
    conf.password='test'
    conf.server='myserver.org'
    conf.port=12345
    conf.set_type('port', int)
    conf.name='test'
    conf.debug=1
    conf.set_type('debug', int)
    
    #load config if possible
    import sys
    if len(sys.argv)==2: conf.load(sys.argv[1])
    else: conf.load()
    
    f=XMPPComponentFactory(conf.password, conf.name+"."+conf.server)
    f.debug=conf.debug
    reactor.connectTCP(conf.server, conf.port, f)
    reactor.run() 

if __name__=='__main__':
    test_component()
