"""
XMLStream handler 
(c) 2003 Fabio Forno fabio.forno@polito.it
This software is Opensource
"""

#PullDOM and minidom are slooow... this part should be completely changed..
#we can parse no more than 300 messages per second; for most clients it acceptable, but for server streams it may be too limiting

import sys, random

from xml.dom import minidom
from xml.dom.pulldom import PullDOM
from xml.sax import make_parser
import xml.sax.handler

from twisted.internet.protocol import Protocol, Factory, ServerFactory, ReconnectingClientFactory

import utils

debug=1

#A modified version of SAX2DOM
class _StreamHandler(PullDOM):

    def __init__(self, caller):
        """ caller: the class handling stream events """
        PullDOM.__init__(self)
        self._caller=caller
        
    def startElementNS(self, name, tagName , attrs):        
        PullDOM.startElementNS(self, name, tagName, attrs)
        #Append children only if the DOM level is more than 2 
        #First level elements are "eaten" all the times
        
        if len(self.elementStack)==2:
            if name==('http://etherx.jabber.org/streams','stream'):
                self._caller.streamOpened(self.lastEvent[0][1])
                #self.pop() #pop the initial element
            else:
                self._caller.closeStream()
                
        elif len(self.elementStack)>3:
            curNode = self.elementStack[-1]
            parentNode = self.elementStack[-2]
            parentNode.appendChild(curNode)
    
    def endElementNS(self, name, tagName):
        PullDOM.endElementNS(self, name, tagName)
        if len(self.elementStack)==2:
            self._caller.elementReceived(self.lastEvent[0][1])
        elif len(self.elementStack)==1:
            self._caller.streamClosed()
        #reset the events (we don't eat events, so we must delete them to
        #avoid memory leaks
        self.firstEvent=[None,None]
        self.lastEvent=self.firstEvent
            
    def processingInstruction(self, target, data):
        PullDOM.processingInstruction(self, target, data)
        node = self.lastEvent[0][1]
        parentNode = self.elementStack[-1]
        parentNode.appendChild(node)

    def ignorableWhitespace(self, chars):
        PullDOM.ignorableWhitespace(self, chars)
        if len(self.elementStack)>2:
            node = self.lastEvent[0][1]
            parentNode = self.elementStack[-1]
            parentNode.appendChild(node)

    def characters(self, chars):
        PullDOM.characters(self, chars)
        if len(self.elementStack)>2:
            node = self.lastEvent[0][1]
            parentNode = self.elementStack[-1]
            parentNode.appendChild(node)

class XMLStream(Protocol):    
    
    def __init__(self):
        self.newParser()
        
    def newParser(self):
        self._parser=make_parser()
        handler=_StreamHandler(self)
        self._parser.setContentHandler(handler)
        self._parser.setFeature(xml.sax.handler.feature_namespaces, 1)
        
    def dataReceived(self, data):
        self._parser.feed(data)

    def streamOpened(self, tag):
        """ Received the first stream event """
        
    def elementReceived(self, tag):
        """ first level element received """
       
    def streamClosed(self):
        """ stream closed event """
           
    def writeElement(self, tag):
        """ write an element to the stream """
        if debug:
            utils.debug(tag.toxml().encode('UTF-8'), xml=1)
        self.transport.write(tag.toxml().encode('UTF-8'))

    def writeData(self, data):
        """ write data to the stream """
        if debug:
            utils.debug(data.encode('UTF-8'), xml=1)
        self.transport.write(data.encode('UTF-8'))


class XMLStreamServerFactory(ServerFactory):    
    """ XMLStream server factory """
    protocol=XMLStream
    xmlns='jabber:client'
    namespaces={'stream':'http://etherx.jabber.org/streams'}
    role='c2s server'
    version='1.0'
    debug=0

class Hollow:
    """ Hollow pattern, 
    see http://slarty.polito.it:8069/~sciasbat/wiki/PythonPython """
    
    def __getattr__(self, k):
        return Hollow()
        
    def __setattr__(self, k, v):
        pass

    def __call__(self, *attr, **kw):
        return Hollow()
    

def _test_XMLStream():
    import sys
    factory=XMLStreamServerFactory()
    stream=factory.buildProtocol(None)    
    stream.transport=Hollow()
    
    r=open(sys.argv[1])
    data = r.read(1024)
    while data:
        stream.dataReceived(data)
        data = r.read(1024)

if __name__=='__main__':
    _test_XMLStream()
