/*
 *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Loic Dachary <loic@gnu.org>
 *
 */
#ifndef exg_error_h
#define exg_error_h

#ifndef EXG_USE_VS_PCH
#include <string>
#include <glib.h>
#include <exg/exg_export.h>
#endif

#ifdef G_HAVE_ISO_VARARGS
#	define g_debug(...)			g_log (G_LOG_DOMAIN, G_LOG_LEVEL_DEBUG, __VA_ARGS__)
#elif defined(G_HAVE_GNUC_VARARGS)
#	define g_debug(format...)   g_log (G_LOG_DOMAIN, G_LOG_LEVEL_DEBUG, format)
#else   /* no varargs macros */
	static void g_debug(const gchar * format, ...)
	{
	va_list args;
	va_start (args, format);
	g_logv (G_LOG_DOMAIN, G_LOG_LEVEL_DEBUG, format, args);
	va_end (args);
	}
#endif  /* !__GNUC__ */

#define UNDERWARE_EXG_ERROR underware_exg_error_quark()

GQuark underware_exg_error_quark(void);

typedef enum {
  UNDERWARE_EXG_ERROR_FAILED, // Generic
} UnderwareExgError;

class EXG_EXPORT EXGError {
public:
  EXGError() : mDomain(0), mCode(0), mMessage(0) { }
  EXGError(GError* error);
  EXGError(gint code, const gchar* format, ...);
  EXGError(GQuark domain, gint code, const gchar* format, ...);
  virtual ~EXGError();

  static void SetVerbose(const std::string& verbose);

protected:
  void Init(GQuark domain, gint code, const gchar* format, va_list ap);

private:
  GQuark mDomain;
  gint mCode;
  gchar* mMessage;
};

#endif // exg_error_h
