/**
   Copyright (C) 2004 Cedric Pinson <cpinson@freesheep.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

   ****************************************************************************
   * @file   exg_file.h
   *
   * @brief   Describe file reference, typically texture 
   *
   *****************************************************************************
   *
   * @author  Cedric Pinson
   *
   * @date    Created 2003/04
   *
   * @version $Id: exg_file.h,v 1.10 2004/10/27 20:37:54 loic Exp $
   *
   ****************************************************************************/
#ifndef exg_file_h
#define exg_file_h

#include <exg/exg_basetypes.h>

namespace exg
{

  /** class used to reference a file, typically used to descibe a texture file
   */
  class File : public VectorString
  {

   protected:

    virtual ~File() {}

   public:

    COMMON_FUNCTIONS(File)

    /**
     *  Default constructor
     */
    File() : VectorString(1) {}


    /**
     *  Set the name of file
     *
     *  @param const std::string& name to set
     */
    void SetName(const std::string& name) {
      (*this)[0]=name;
    }



    /**
     *  Return the name of file
     *
     *  @return const char* name of file
     */
    const std::string& GetName() const {
      return (*this)[0];
    }

    Object* Clone() {
      File* n=new File(*this);
      return n;
    }


    virtual File* AsFile(void) { return this; }
    virtual const File* AsFile(void) const { return this; }
    virtual int GetType(void) const { return FILE; }
    inline static Object* Create() { return new File; }

  };

}


#endif
