/**
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 ****************************************************************************
 * @file   exg_quaternion.h
 *****************************************************************************
 * @author  Sylvain Grosdemouge
 ****************************************************************************/

#ifndef exg_quaternion_h
#define exg_quaternion_h

#include <exg/exg_vector4.h>

namespace exg
{
	template <class T> class Quaternion
	{
	public:

		enum EValue
		{
			e_value_x,
			e_value_y,
			e_value_z,
			e_value_w,
			e_value_max,
		};
	
		explicit Quaternion(void)
		{

		}

		explicit Quaternion(T x, T y, T z, T w)
		{
			setXYZW(x, y, z, w);
		}

		Quaternion(const Quaternion& q)
		{
			(*this) = q;
		}

		virtual ~Quaternion(void)
		{

		}

		inline void			setX	(const T & x)	{ m_pValues[e_value_x] = x; }
		inline const T &	getX	(void) const	{ return(m_pValues[e_value_x]); }
		inline T &			getX	(void)			{ return(m_pValues[e_value_x]); }

		inline void			setY	(const T & y)	{ m_pValues[e_value_y] = y; }
		inline const T &	getY	(void) const	{ return(m_pValues[e_value_y]); }
		inline T &			getY	(void)			{ return(m_pValues[e_value_y]); }

		inline void			setZ	(const T & z)	{ m_pValues[e_value_z] = z; }
		inline const T &	getZ	(void) const	{ return(m_pValues[e_value_z]); }
		inline T &			getZ	(void)			{ return(m_pValues[e_value_z]); }

		inline void			setW	(const T & w)	{ m_pValues[e_value_w] = w; }
		inline const T &	getW	(void) const	{ return(m_pValues[e_value_w]); }
		inline T &			getW	(void)			{ return(m_pValues[e_value_w]); }

		inline void			setXYZW	(const T & x, const T & y, const T & z, const T & w)
		{
			setX(x);
			setY(y);
			setZ(z);
			setW(w);
		}

		inline void operator = (const Quaternion<T> & q)
		{
			for (int nValue = 0 ; nValue < e_value_max ; ++nValue)
			{
				m_pValues[nValue] = q.m_pValues[nValue];
			}
		}

		inline bool operator == (const Quaternion<T> & q)
		{
			for (int nValue = 0 ; nValue < e_value_max ; ++nValue)
			{
				if (m_pValues[nValue] != q[nValue])
				{
					return(false);
				}
			}

			return(true);
		}

		inline bool operator != (const Quaternion<T> & q)
		{
			for (int nValue = 0 ; nValue < e_value_max ; ++nValue)
			{
				if (m_pValues[nValue] != q[nValue])
				{
					return(true);
				}
			}

			return(false);
		}

		inline T & operator [] (int nValue)
		{
			//ASSERT(DEBUG_LEVEL_MAX, nValue < e_value_max);
			return(m_pValues[nValue]);
		}

		inline const T & operator [] (int nValue) const
		{
			//ASSERT(DEBUG_LEVEL_MAX, nValue < e_value_max);
			return(m_pValues[nValue]);
		}

	public:

		T	m_pValues[e_value_max];

	};

	typedef Quaternion<float> Quaternionf;
	typedef Quaternion<double> Quaterniond;
}

#endif
