/**
   Copyright (C) 2004 Cedric Pinson <cpinson@freesheep.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

   ****************************************************************************
   * @file   exg_scene_node.h
   *
   * @brief   base for mesh exchange
   *
   *****************************************************************************
   *
   * @author  Cedric Pinson
   *
   * @date    Created 2004/04
   *
   * @version $Id: exg_scene_node.h,v 1.1 2004/04/12 20:59:03 cpinson Exp $
   *
   ****************************************************************************/


#ifndef exg_scene_node_h
#define exg_scene_node_h

#include <string>
#include <exg/exg_basetypes.h>

namespace exg
{

  

  class EXG_EXPORT NodeGroup : public MapObjectPointer
  {

   public:
    META_Object(NodeGroup)

    /// Default constructor
    NodeGroup() {
      
      (*this)["nodes"]=new VectorObjectPointer;
    }


    void Traverse(Visitor& visitor);

    NodeGroup* AsNodeGroup() { return this; }
    const NodeGroup* AsNodeGroup(void) const { return this; }
    int GetType() const { return NODEGROUP; }
    inline static Object* Create() { return new NodeGroup; }

    std::ostream& operator<<(std::ostream& o);

  };




  class EXG_EXPORT NodeTransform : public NodeGroup
  {

   public:

    META_Object(NodeTransform)

    /// Default constructor
    NodeTransform() {
      (*this)["transform"]=new ObjectMatrix4;
    }


    void Traverse(Visitor& visitor);

    NodeTransform* AsNodeTransform() { return this; }
    const NodeTransform* AsNodeTransform() const { return this; }
    int GetType() const { return NODETRANSFORM; }
    inline static Object* Create() { return new NodeTransform; }

    std::ostream& operator<<(std::ostream& o);

  };



  class EXG_EXPORT NodeFile : public MapObjectPointer
  {

   public:

    META_Object(NodeFile)

    /// Default constructor
    NodeFile() {
      (*this)["file"]=new File;
    }


    void Traverse(Visitor& visitor);

    NodeFile* AsNodeFile() { return this; }
    const NodeFile* AsNodeFile() const { return this; }
    int GetType() const { return NODEFILE; }
    inline static Object* Create() { return new NodeFile; }

    std::ostream& operator<<(std::ostream& o);

  };



  class EXG_EXPORT NodeLight : public MapObjectPointer
  {

   public:

    META_Object(NodeLight)

    /// Default constructor
    NodeLight() {
      (*this)["color"]=new VectorFloat(4);
    }

    NodeLight* AsNodeLight() { return this; }
    const NodeLight* AsNodeLight() const { return this; }
    int GetType() const { return NODELIGHT; }
    inline static Object* Create() { return new NodeLight; }

  };



  class EXG_EXPORT NodeAmbientLight : public NodeLight
  {

   public:

    META_Object(NodeAmbientLight)

    /// Default constructor
    NodeAmbientLight() {}

    void Traverse(Visitor& visitor);

    NodeAmbientLight* AsNodeAmbientLight() { return this; }
    const NodeAmbientLight* AsNodeAmbientLight() const { return this; }
    int GetType() const { return NODEAMBIENTLIGHT; }
    inline static Object* Create() { return new NodeAmbientLight; }

  };



  class EXG_EXPORT NodeDirectionalLight : public NodeLight
  {

   public:

    META_Object(NodeDirectionalLight)

    /// Default constructor
    NodeDirectionalLight() {
      (*this)["direction"]=new VectorFloat(3);
    }

    Vector3 GetDirection(){ return (*this)["direction"];}

    

    void Traverse(Visitor& visitor);

    NodeDirectionalLight* AsNodeDirectionalLight() { return this; }
    const NodeDirectionalLight* AsNodeDirectionalLight() const { return this; }
    int GetType() const { return NODEDIRECTIONALLIGHT; }
    inline static Object* Create() { return new NodeDirectionalLight; }

  };



  class EXG_EXPORT NodePointLight : public NodeLight
  {

   public:

    META_Object(NodePointLight)

    /// Default constructor
    NodePointLight() {
      (*this)["radius"]=new VectorFloat(1);
    }

    float GetRadius() { return 0;}
    void SetRadius(float radius) { ;}


    void Traverse(Visitor& visitor);

    NodePointLight* AsNodePointLight() { return this; }
    const NodePointLight* AsNodePointLight() const { return this; }
    int GetType() const { return NODEPOINTLIGHT; }
    inline static Object* Create() { return new NodePointLight; }

  };




  class EXG_EXPORT NodeSpotLight : public NodeDirectionalLight
  {

   public:

    META_Object(NodeSpotLight)

    /// Default constructor
    NodeSpotLight() {
      (*this)["radius"]=new VectorFloat(1);
      (*this)["cutoff"]=new VectorFloat(1);
    }

    float GetRadius() { return 0;}
    void SetRadius(float radius) { ;}

    float GetCutOff() { return 0;}
    void SetCutOff(float cut) { ;}


    void Traverse(Visitor& visitor);

    NodeSpotLight* AsNodeSpotLight() { return this; }
    const NodeSpotLight* AsNodeSpotLight() const { return this; }
    int GetType() const { return NODESPOTLIGHT; }
    inline static Object* Create() { return new NodeSpotLight; }

  };


}

#endif         
