/* -*-c++-*- OpenSceneGraph - Copyright (C) 1998-2003 Robert Osfield 
 *
 * This library is open source and may be redistributed and/or modified under  
 * the terms of the OpenSceneGraph Public License (OSGPL) version 0.0 or 
 * (at your option) any later version.  The full license is in LICENSE file
 * included with this distribution, and on the openscenegraph.org website.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 * OpenSceneGraph Public License for more details.
 */

#ifndef exg_nodevisitor_utils_h
#define exg_nodevisitor_utils_h

#include <exg/exg_visitor.h>
#include <exg/exg_matrix4.h>

namespace exg {

  /**
   *  Dump a mesh in stdout
   */
  class EXG_EXPORT VisitorDump : public Visitor
  {
   public:

    VisitorDump():Visitor(ONCE){}

    void Apply(Object& node);
    void Apply(Material& node);
    void Apply(Polygon& node);
    void Apply(Vertex& node);
    void Apply(Point& node);
    void Apply(Mesh& node);
    void Apply(File& node);
  };

  /**
   *  Remove a normal on a material and polygon
   *
   */
  class EXG_EXPORT VisitorRemoveNormal : public Visitor
  {
   public:

    VisitorRemoveNormal():Visitor(ONCE) {}

    void Apply(Material& node);
    void Apply(Vertex& node);
  };

  /**
   *  Remove a texture channel with the given name of channel
   */
  class EXG_EXPORT VisitorRemoveTextureChannel : public Visitor
  {

    std::string mChannel;

   public:

    VisitorRemoveTextureChannel(const std::string& channel):Visitor(ONCE),mChannel(channel) {}

    void Apply(Material& node);
    void Apply(Vertex& node);
  };



  /**
   *  Transform
   */
  class EXG_EXPORT VisitorTransform : public Visitor
  {

    Matrix4f mTransform;

  public:

    VisitorTransform(const Matrix4f& transform):Visitor(ONCE),mTransform(transform){}

    void Apply(Point& node);
    void Apply(Vertex& node);
  };



}

#endif
